% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_delete_environment_configuration}
\alias{elasticbeanstalk_delete_environment_configuration}
\title{Deletes the draft configuration associated with the running environment}
\usage{
elasticbeanstalk_delete_environment_configuration(ApplicationName,
  EnvironmentName)
}
\arguments{
\item{ApplicationName}{[required] The name of the application the environment is associated with.}

\item{EnvironmentName}{[required] The name of the environment to delete the draft configuration from.}
}
\description{
Deletes the draft configuration associated with the running environment.
}
\details{
Updating a running environment with any configuration changes creates a
draft configuration set. You can get the draft configuration using
DescribeConfigurationSettings while the update is in progress or if the
update fails. The \code{DeploymentStatus} for the draft configuration
indicates whether the deployment is in process or has failed. The draft
configuration remains in existence until it is deleted with this action.
}
\section{Request syntax}{
\preformatted{svc$delete_environment_configuration(
  ApplicationName = "string",
  EnvironmentName = "string"
)
}
}

\examples{
\dontrun{
# The following operation deletes a draft configuration for an environment
# named my-env:
svc$delete_environment_configuration(
  ApplicationName = "my-app",
  EnvironmentName = "my-env"
)
}

}
\keyword{internal}
