% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_delete_cluster}
\alias{ecs_delete_cluster}
\title{Deletes the specified cluster}
\usage{
ecs_delete_cluster(cluster)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster to
delete.}
}
\description{
Deletes the specified cluster. You must deregister all container
instances from this cluster before you may delete it. You can list the
container instances in a cluster with ListContainerInstances and
deregister them with DeregisterContainerInstance.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster(
  cluster = "string"
)
}
}

\examples{
\dontrun{
# This example deletes an empty cluster in your default region.
svc$delete_cluster(
  cluster = "my_cluster"
)
}

}
\keyword{internal}
