% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_delete_job_queue}
\alias{batch_delete_job_queue}
\title{Deletes the specified job queue}
\usage{
batch_delete_job_queue(jobQueue)
}
\arguments{
\item{jobQueue}{[required] The short name or full Amazon Resource Name (ARN) of the queue to
delete.}
}
\description{
Deletes the specified job queue. You must first disable submissions for
a queue with the UpdateJobQueue operation. All jobs in the queue are
terminated when you delete a job queue.
}
\details{
It is not necessary to disassociate compute environments from a queue
before submitting a \code{DeleteJobQueue} request.
}
\section{Request syntax}{
\preformatted{svc$delete_job_queue(
  jobQueue = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the GPGPU job queue.
svc$delete_job_queue(
  jobQueue = "GPGPU"
)
}

}
\keyword{internal}
