% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_create_nodegroup}
\alias{eks_create_nodegroup}
\title{Creates a managed worker node group for an Amazon EKS cluster}
\usage{
eks_create_nodegroup(clusterName, nodegroupName, scalingConfig,
  diskSize, subnets, instanceTypes, amiType, remoteAccess, nodeRole,
  labels, tags, clientRequestToken, version, releaseVersion)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to create the node group in.}

\item{nodegroupName}{[required] The unique name to give your node group.}

\item{scalingConfig}{The scaling configuration details for the Auto Scaling group that is
created for your node group.}

\item{diskSize}{The root device disk size (in GiB) for your node group instances. The
default disk size is 20 GiB.}

\item{subnets}{[required] The subnets to use for the Auto Scaling group that is created for your
node group. These subnets must have the tag key
\code{kubernetes.io/cluster/CLUSTER_NAME} with a value of \code{shared}, where
\code{CLUSTER_NAME} is replaced with the name of your cluster.}

\item{instanceTypes}{The instance type to use for your node group. Currently, you can specify
a single instance type for a node group. The default value for this
parameter is \code{t3.medium}. If you choose a GPU instance type, be sure to
specify the \code{AL2_x86_64_GPU} with the \code{amiType} parameter.}

\item{amiType}{The AMI type for your node group. GPU instance types should use the
\code{AL2_x86_64_GPU} AMI type, which uses the Amazon EKS-optimized Linux AMI
with GPU support. Non-GPU instances should use the \code{AL2_x86_64} AMI
type, which uses the Amazon EKS-optimized Linux AMI.}

\item{remoteAccess}{The remote access (SSH) configuration to use with your node group.}

\item{nodeRole}{[required] The IAM role associated with your node group. The Amazon EKS worker node
\code{kubelet} daemon makes calls to AWS APIs on your behalf. Worker nodes
receive permissions for these API calls through an IAM instance profile
and associated policies. Before you can launch worker nodes and register
them into a cluster, you must create an IAM role for those worker nodes
to use when they are launched. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html}{Amazon EKS Worker Node IAM Role}
in the \strong{Amazon EKS User Guide} .}

\item{labels}{The Kubernetes labels to be applied to the nodes in the node group when
they are created.}

\item{tags}{The metadata to apply to the node group to assist with categorization
and organization. Each tag consists of a key and an optional value, both
of which you define. Node group tags do not propagate to any other
resources associated with the node group, such as the Amazon EC2
instances or subnets.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{version}{The Kubernetes version to use for your managed nodes. By default, the
Kubernetes version of the cluster is used, and this is the only accepted
specified value.}

\item{releaseVersion}{The AMI version of the Amazon EKS-optimized AMI to use with your node
group. By default, the latest available AMI version for the node
group\'s current Kubernetes version is used. For more information, see
\href{https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html}{Amazon EKS-Optimized Linux AMI Versions}
in the \emph{Amazon EKS User Guide}.}
}
\description{
Creates a managed worker node group for an Amazon EKS cluster. You can
only create a node group for your cluster that is equal to the current
Kubernetes version for the cluster. All node groups are created with the
latest AMI release version for the respective minor Kubernetes version
of the cluster.
}
\details{
An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
associated Amazon EC2 instances that are managed by AWS for an Amazon
EKS cluster. Each node group uses a version of the Amazon EKS-optimized
Amazon Linux 2 AMI. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html}{Managed Node Groups}
in the \emph{Amazon EKS User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_nodegroup(
  clusterName = "string",
  nodegroupName = "string",
  scalingConfig = list(
    minSize = 123,
    maxSize = 123,
    desiredSize = 123
  ),
  diskSize = 123,
  subnets = list(
    "string"
  ),
  instanceTypes = list(
    "string"
  ),
  amiType = "AL2_x86_64"|"AL2_x86_64_GPU",
  remoteAccess = list(
    ec2SshKey = "string",
    sourceSecurityGroups = list(
      "string"
    )
  ),
  nodeRole = "string",
  labels = list(
    "string"
  ),
  tags = list(
    "string"
  ),
  clientRequestToken = "string",
  version = "string",
  releaseVersion = "string"
)
}
}

\keyword{internal}
