% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_submit_task_state_change}
\alias{ecs_submit_task_state_change}
\title{This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent}
\usage{
ecs_submit_task_state_change(cluster, task, status, reason, containers,
  attachments, pullStartedAt, pullStoppedAt, executionStoppedAt)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the task.}

\item{task}{The task ID or full ARN of the task in the state change request.}

\item{status}{The status of the state change request.}

\item{reason}{The reason for the state change request.}

\item{containers}{Any containers associated with the state change request.}

\item{attachments}{Any attachments associated with the state change request.}

\item{pullStartedAt}{The Unix timestamp for when the container image pull began.}

\item{pullStoppedAt}{The Unix timestamp for when the container image pull completed.}

\item{executionStoppedAt}{The Unix timestamp for when the task execution stopped.}
}
\description{
This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent.
}
\details{
Sent to acknowledge that a task changed states.
}
\section{Request syntax}{
\preformatted{svc$submit_task_state_change(
  cluster = "string",
  task = "string",
  status = "string",
  reason = "string",
  containers = list(
    list(
      containerName = "string",
      exitCode = 123,
      networkBindings = list(
        list(
          bindIP = "string",
          containerPort = 123,
          hostPort = 123,
          protocol = "tcp"|"udp"
        )
      ),
      reason = "string",
      status = "string"
    )
  ),
  attachments = list(
    list(
      attachmentArn = "string",
      status = "string"
    )
  ),
  pullStartedAt = as.POSIXct(
    "2015-01-01"
  ),
  pullStoppedAt = as.POSIXct(
    "2015-01-01"
  ),
  executionStoppedAt = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
