% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_get_lifecycle_policy_preview}
\alias{ecr_get_lifecycle_policy_preview}
\title{Retrieves the results of the specified lifecycle policy preview request}
\usage{
ecr_get_lifecycle_policy_preview(registryId, repositoryName, imageIds,
  nextToken, maxResults, filter)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository.}

\item{imageIds}{The list of imageIDs to be included.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginatedâ€¨
\code{GetLifecyclePolicyPreviewRequest} request where \code{maxResults} was used
and theâ€¨ results exceeded the value of that parameter. Pagination
continues from the end of theâ€¨ previous results that returned the
\code{nextToken} value. This value isâ€¨ \code{null} when there are no more results
to return. This option cannot be used when you specify images with
\code{imageIds}.}

\item{maxResults}{The maximum number of repository results returned by
\code{GetLifecyclePolicyPreviewRequest} inâ€¨ paginated output. When this
parameter is used, \code{GetLifecyclePolicyPreviewRequest} only returnsâ€¨
\code{maxResults} results in a single page along with a \code{nextToken}â€¨ response
element. The remaining results of the initial request can be seen by
sendingâ€¨ another \code{GetLifecyclePolicyPreviewRequest} request with the
returned \code{nextToken}â€¨ value. This value can be between 1 and 1000. If
thisâ€¨ parameter is not used, then \code{GetLifecyclePolicyPreviewRequest}
returns up toâ€¨ 100 results and a \code{nextToken} value, ifâ€¨ applicable. This
option cannot be used when you specify images with \code{imageIds}.}

\item{filter}{An optional parameter that filters results based on image tag status and
all tags, if tagged.}
}
\description{
Retrieves the results of the specified lifecycle policy preview request.
}
\section{Request syntax}{
\preformatted{svc$get_lifecycle_policy_preview(
  registryId = "string",
  repositoryName = "string",
  imageIds = list(
    list(
      imageDigest = "string",
      imageTag = "string"
    )
  ),
  nextToken = "string",
  maxResults = 123,
  filter = list(
    tagStatus = "TAGGED"|"UNTAGGED"|"ANY"
  )
)
}
}

\keyword{internal}
