% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_transit_gateway_attachment_propagations}
\alias{ec2_get_transit_gateway_attachment_propagations}
\title{Lists the route tables to which the specified resource attachment
propagates routes}
\usage{
ec2_get_transit_gateway_attachment_propagations(
  TransitGatewayAttachmentId, Filters, MaxResults, NextToken, DryRun)
}
\arguments{
\item{TransitGatewayAttachmentId}{[required] The ID of the attachment.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{transit-gateway-route-table-id} - The ID of the transit gateway
route table.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGatewayAttachmentPropagations = list(
    list(
      TransitGatewayRouteTableId = "string",
      State = "enabling"|"enabled"|"disabling"|"disabled"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the route tables to which the specified resource attachment
propagates routes.
}
\section{Request syntax}{
\preformatted{svc$get_transit_gateway_attachment_propagations(
  TransitGatewayAttachmentId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
