% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_export_snapshot_records}
\alias{lightsail_get_export_snapshot_records}
\title{Returns the export snapshot record created as a result of the export
snapshot operation}
\usage{
lightsail_get_export_snapshot_records(pageToken)
}
\arguments{
\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_export_snapshot_records]{get_export_snapshot_records}}
request. If your results are paginated, the response will return a next
page token that you can specify as the page token in a subsequent
request.}
}
\value{
A list with the following syntax:\preformatted{list(
  exportSnapshotRecords = list(
    list(
      name = "string",
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      state = "Started"|"Succeeded"|"Failed",
      sourceInfo = list(
        resourceType = "InstanceSnapshot"|"DiskSnapshot",
        createdAt = as.POSIXct(
          "2015-01-01"
        ),
        name = "string",
        arn = "string",
        fromResourceName = "string",
        fromResourceArn = "string",
        instanceSnapshotInfo = list(
          fromBundleId = "string",
          fromBlueprintId = "string",
          fromDiskInfo = list(
            list(
              name = "string",
              path = "string",
              sizeInGb = 123,
              isSystemDisk = TRUE|FALSE
            )
          )
        ),
        diskSnapshotInfo = list(
          sizeInGb = 123
        )
      ),
      destinationInfo = list(
        id = "string",
        service = "string"
      )
    )
  ),
  nextPageToken = "string"
)
}
}
\description{
Returns the export snapshot record created as a result of the
\verb{export snapshot} operation.

An export snapshot record can be used to create a new Amazon EC2
instance and its related resources with the
\verb{create cloud formation stack} operation.
}
\section{Request syntax}{
\preformatted{svc$get_export_snapshot_records(
  pageToken = "string"
)
}
}

\keyword{internal}
