% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_container_services}
\alias{lightsail_get_container_services}
\title{Returns information about one or more of your Amazon Lightsail container
services}
\usage{
lightsail_get_container_services(serviceName)
}
\arguments{
\item{serviceName}{The name of the container service for which to return information.

When omitted, the response includes all of your container services in
the AWS Region where the request is made.}
}
\value{
A list with the following syntax:\preformatted{list(
  containerServices = list(
    list(
      containerServiceName = "string",
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
      powerId = "string",
      state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
      scale = 123,
      currentDeployment = list(
        version = 123,
        state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
        containers = list(
          list(
            image = "string",
            command = list(
              "string"
            ),
            environment = list(
              "string"
            ),
            ports = list(
              "HTTP"|"HTTPS"|"TCP"|"UDP"
            )
          )
        ),
        publicEndpoint = list(
          containerName = "string",
          containerPort = 123,
          healthCheck = list(
            healthyThreshold = 123,
            unhealthyThreshold = 123,
            timeoutSeconds = 123,
            intervalSeconds = 123,
            path = "string",
            successCodes = "string"
          )
        ),
        createdAt = as.POSIXct(
          "2015-01-01"
        )
      ),
      nextDeployment = list(
        version = 123,
        state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
        containers = list(
          list(
            image = "string",
            command = list(
              "string"
            ),
            environment = list(
              "string"
            ),
            ports = list(
              "HTTP"|"HTTPS"|"TCP"|"UDP"
            )
          )
        ),
        publicEndpoint = list(
          containerName = "string",
          containerPort = 123,
          healthCheck = list(
            healthyThreshold = 123,
            unhealthyThreshold = 123,
            timeoutSeconds = 123,
            intervalSeconds = 123,
            path = "string",
            successCodes = "string"
          )
        ),
        createdAt = as.POSIXct(
          "2015-01-01"
        )
      ),
      isDisabled = TRUE|FALSE,
      principalArn = "string",
      privateDomainName = "string",
      publicDomainNames = list(
        list(
          "string"
        )
      ),
      url = "string"
    )
  )
)
}
}
\description{
Returns information about one or more of your Amazon Lightsail container
services.
}
\section{Request syntax}{
\preformatted{svc$get_container_services(
  serviceName = "string"
)
}
}

\keyword{internal}
