% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_layer_version}
\alias{lambda_get_layer_version}
\title{Returns information about a version of an AWS Lambda layer, with a link
to download the layer archive that's valid for 10 minutes}
\usage{
lambda_get_layer_version(LayerName, VersionNumber)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{VersionNumber}{[required] The version number.}
}
\value{
A list with the following syntax:\preformatted{list(
  Content = list(
    Location = "string",
    CodeSha256 = "string",
    CodeSize = 123,
    SigningProfileVersionArn = "string",
    SigningJobArn = "string"
  ),
  LayerArn = "string",
  LayerVersionArn = "string",
  Description = "string",
  CreatedDate = "string",
  Version = 123,
  CompatibleRuntimes = list(
    "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2"
  ),
  LicenseInfo = "string"
)
}
}
\description{
Returns information about a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer},
with a link to download the layer archive that's valid for 10 minutes.
}
\section{Request syntax}{
\preformatted{svc$get_layer_version(
  LayerName = "string",
  VersionNumber = 123
)
}
}

\examples{
\dontrun{
# The following example returns information for version 1 of a layer named
# my-layer.
svc$get_layer_version(
  LayerName = "my-layer",
  VersionNumber = 1L
)
}

}
\keyword{internal}
