% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_attribute}
\alias{ec2_modify_vpc_attribute}
\title{Modifies the specified attribute of the specified VPC}
\usage{
ec2_modify_vpc_attribute(EnableDnsHostnames, EnableDnsSupport, VpcId)
}
\arguments{
\item{EnableDnsHostnames}{Indicates whether the instances launched in the VPC get DNS hostnames.
If enabled, instances in the VPC get DNS hostnames; otherwise, they do
not.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute. You can only
enable DNS hostnames if you've enabled DNS support.}

\item{EnableDnsSupport}{Indicates whether the DNS resolution is supported for the VPC. If
enabled, queries to the Amazon provided DNS server at the
169.254.169.253 IP address, or the reserved IP address at the base of
the VPC network range "plus two" succeed. If disabled, the Amazon
provided DNS service in the VPC that resolves public DNS hostnames to IP
addresses is not enabled.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute.}

\item{VpcId}{[required] The ID of the VPC.}
}
\value{
An empty list.
}
\description{
Modifies the specified attribute of the specified VPC.
}
\section{Request syntax}{
\preformatted{svc$modify_vpc_attribute(
  EnableDnsHostnames = list(
    Value = TRUE|FALSE
  ),
  EnableDnsSupport = list(
    Value = TRUE|FALSE
  ),
  VpcId = "string"
)
}
}

\examples{
\dontrun{
# This example modifies the enableDnsSupport attribute. This attribute
# indicates whether DNS resolution is enabled for the VPC. If this
# attribute is true, the Amazon DNS server resolves DNS hostnames for
# instances in the VPC to their corresponding IP addresses; otherwise, it
# does not.
svc$modify_vpc_attribute(
  EnableDnsSupport = list(
    Value = FALSE
  ),
  VpcId = "vpc-a01106c2"
)

# This example modifies the enableDnsHostnames attribute. This attribute
# indicates whether instances launched in the VPC get DNS hostnames. If
# this attribute is true, instances in the VPC get DNS hostnames;
# otherwise, they do not.
svc$modify_vpc_attribute(
  EnableDnsHostnames = list(
    Value = FALSE
  ),
  VpcId = "vpc-a01106c2"
)
}

}
\keyword{internal}
