% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_receive_message}
\alias{sqs_receive_message}
\title{Retrieves one or more messages (up to 10), from the specified queue}
\usage{
sqs_receive_message(QueueUrl, AttributeNames, MessageAttributeNames,
  MaxNumberOfMessages, VisibilityTimeout, WaitTimeSeconds,
  ReceiveRequestAttemptId)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue from which messages are received.

Queue URLs and names are case-sensitive.}

\item{AttributeNames}{A list of attributes that need to be returned along with each message.
These attributes include:
\itemize{
\item \code{All} - Returns all values.
\item \code{ApproximateFirstReceiveTimestamp} - Returns the time the message
was first received from the queue (\href{http://en.wikipedia.org/wiki/Unix_time}{epoch time} in milliseconds).
\item \code{ApproximateReceiveCount} - Returns the number of times a message
has been received from the queue but not deleted.
\item \code{AWSTraceHeader} - Returns the AWS X-Ray trace header string.
\item \code{SenderId}
\itemize{
\item For an IAM user, returns the IAM user ID, for example
\code{ABCDEFGHI1JKLMNOPQ23R}.
\item For an IAM role, returns the IAM role ID, for example
\code{ABCDE1F2GH3I4JK5LMNOP:i-a123b456}.
}
\item \code{SentTimestamp} - Returns the time the message was sent to the queue
(\href{http://en.wikipedia.org/wiki/Unix_time}{epoch time} in
milliseconds).
\item \code{MessageDeduplicationId} - Returns the value provided by the
producer that calls the \verb{<a>SendMessage</a>} action.
\item \code{MessageGroupId} - Returns the value provided by the producer that
calls the \verb{<a>SendMessage</a>} action. Messages with the same
\code{MessageGroupId} are returned in sequence.
\item \code{SequenceNumber} - Returns the value provided by Amazon SQS.
}}

\item{MessageAttributeNames}{The name of the message attribute, where \emph{N} is the index.
\itemize{
\item The name can contain alphanumeric characters and the underscore
(\verb{_}), hyphen (\code{-}), and period (\code{.}).
\item The name is case-sensitive and must be unique among all attribute
names for the message.
\item The name must not start with AWS-reserved prefixes such as \code{AWS.} or
\code{Amazon.} (or any casing variants).
\item The name must not start or end with a period (\code{.}), and it should
not have periods in succession (\code{..}).
\item The name can be up to 256 characters long.
}

When using \code{ReceiveMessage}, you can send a list of attribute names to
receive, or you can return all of the attributes by specifying \code{All} or
\verb{.*} in your request. You can also use all message attributes starting
with a prefix, for example \verb{bar.*}.}

\item{MaxNumberOfMessages}{The maximum number of messages to return. Amazon SQS never returns more
messages than this value (however, fewer messages might be returned).
Valid values: 1 to 10. Default: 1.}

\item{VisibilityTimeout}{The duration (in seconds) that the received messages are hidden from
subsequent retrieve requests after being retrieved by a \code{ReceiveMessage}
request.}

\item{WaitTimeSeconds}{The duration (in seconds) for which the call waits for a message to
arrive in the queue before returning. If a message is available, the
call returns sooner than \code{WaitTimeSeconds}. If no messages are available
and the wait time expires, the call returns successfully with an empty
list of messages.}

\item{ReceiveRequestAttemptId}{This parameter applies only to FIFO (first-in-first-out) queues.

The token used for deduplication of \code{ReceiveMessage} calls. If a
networking issue occurs after a \code{ReceiveMessage} action, and instead of
a response you receive a generic error, you can retry the same action
with an identical \code{ReceiveRequestAttemptId} to retrieve the same set of
messages, even if their visibility timeout has not yet expired.
\itemize{
\item You can use \code{ReceiveRequestAttemptId} only for 5 minutes after a
\code{ReceiveMessage} action.
\item When you set \code{FifoQueue}, a caller of the \code{ReceiveMessage} action
can provide a \code{ReceiveRequestAttemptId} explicitly.
\item If a caller of the \code{ReceiveMessage} action doesn\'t provide a
\code{ReceiveRequestAttemptId}, Amazon SQS generates a
\code{ReceiveRequestAttemptId}.
\item You can retry the \code{ReceiveMessage} action with the same
\code{ReceiveRequestAttemptId} if none of the messages have been modified
(deleted or had their visibility changes).
\item During a visibility timeout, subsequent calls with the same
\code{ReceiveRequestAttemptId} return the same messages and receipt
handles. If a retry occurs within the deduplication interval, it
resets the visibility timeout. For more information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html}{Visibility Timeout}
in the \emph{Amazon Simple Queue Service Developer Guide}.

If a caller of the \code{ReceiveMessage} action still processes messages
when the visibility timeout expires and messages become visible,
another worker consuming from the same queue can receive the same
messages and therefore process duplicates. Also, if a consumer whose
message processing time is longer than the visibility timeout tries
to delete the processed messages, the action fails with an error.

To mitigate this effect, ensure that your application observes a
safe threshold before the visibility timeout expires and extend the
visibility timeout as necessary.
\item While messages with a particular \code{MessageGroupId} are invisible, no
more messages belonging to the same \code{MessageGroupId} are returned
until the visibility timeout expires. You can still receive messages
with another \code{MessageGroupId} as long as it is also visible.
\item If a caller of \code{ReceiveMessage} can\'t track the
\code{ReceiveRequestAttemptId}, no retries work until the original
visibility timeout expires. As a result, delays might occur but the
messages in the queue remain in a strict order.
}

The length of \code{ReceiveRequestAttemptId} is 128 characters.
\code{ReceiveRequestAttemptId} can contain alphanumeric characters (\code{a-z},
\code{A-Z}, \code{0-9}) and punctuation
(\verb{!\\"#$\\\%&amp;\\'()*+,-./:;&lt;=&gt;?@\\\[\\\\\]^_\\`\\\{|\\\}~}).

For best practices of using \code{ReceiveRequestAttemptId}, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html}{Using the ReceiveRequestAttemptId Request Parameter}
in the \emph{Amazon Simple Queue Service Developer Guide}.}
}
\description{
Retrieves one or more messages (up to 10), from the specified queue.
Using the \code{WaitTimeSeconds} parameter enables long-poll support. For
more information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html}{Amazon SQS Long Polling}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\details{
Short poll is the default behavior where a weighted random set of
machines is sampled on a \code{ReceiveMessage} call. Thus, only the messages
on the sampled machines are returned. If the number of messages in the
queue is small (fewer than 1,000), you most likely get fewer messages
than you requested per \code{ReceiveMessage} call. If the number of messages
in the queue is extremely small, you might not receive any messages in a
particular \code{ReceiveMessage} response. If this happens, repeat the
request.

For each message returned, the response includes the following:
\itemize{
\item The message body.
\item An MD5 digest of the message body. For information about MD5, see
\href{https://www.ietf.org/rfc/rfc1321.txt}{RFC1321}.
\item The \code{MessageId} you received when you sent the message to the queue.
\item The receipt handle.
\item The message attributes.
\item An MD5 digest of the message attributes.
}

The receipt handle is the identifier you must provide when deleting the
message. For more information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html}{Queue and Message Identifiers}
in the \emph{Amazon Simple Queue Service Developer Guide}.

You can provide the \code{VisibilityTimeout} parameter in your request. The
parameter is applied to the messages that Amazon SQS returns in the
response. If you don\'t include the parameter, the overall visibility
timeout for the queue is used for the returned messages. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html}{Visibility Timeout}
in the \emph{Amazon Simple Queue Service Developer Guide}.

A message that isn\'t deleted or a message whose visibility isn\'t
extended before the visibility timeout expires counts as a failed
receive. Depending on the configuration of the queue, the message might
be sent to the dead-letter queue.

In the future, new attributes might be added. If you write code that
calls this action, we recommend that you structure your code so that it
can handle new attributes gracefully.
}
\section{Request syntax}{
\preformatted{svc$receive_message(
  QueueUrl = "string",
  AttributeNames = list(
    "All"|"Policy"|"VisibilityTimeout"|"MaximumMessageSize"|"MessageRetentionPeriod"|"ApproximateNumberOfMessages"|"ApproximateNumberOfMessagesNotVisible"|"CreatedTimestamp"|"LastModifiedTimestamp"|"QueueArn"|"ApproximateNumberOfMessagesDelayed"|"DelaySeconds"|"ReceiveMessageWaitTimeSeconds"|"RedrivePolicy"|"FifoQueue"|"ContentBasedDeduplication"|"KmsMasterKeyId"|"KmsDataKeyReusePeriodSeconds"
  ),
  MessageAttributeNames = list(
    "string"
  ),
  MaxNumberOfMessages = 123,
  VisibilityTimeout = 123,
  WaitTimeSeconds = 123,
  ReceiveRequestAttemptId = "string"
)
}
}

\keyword{internal}
