% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchserviceserverless_operations.R
\name{opensearchserviceserverless_update_vpc_endpoint}
\alias{opensearchserviceserverless_update_vpc_endpoint}
\title{Updates an OpenSearch Serverless-managed interface endpoint}
\usage{
opensearchserviceserverless_update_vpc_endpoint(
  addSecurityGroupIds = NULL,
  addSubnetIds = NULL,
  clientToken = NULL,
  id,
  removeSecurityGroupIds = NULL,
  removeSubnetIds = NULL
)
}
\arguments{
\item{addSecurityGroupIds}{The unique identifiers of the security groups to add to the endpoint.
Security groups define the ports, protocols, and sources for inbound
traffic that you are authorizing into your endpoint.}

\item{addSubnetIds}{The ID of one or more subnets to add to the endpoint.}

\item{clientToken}{Unique, case-sensitive identifier to ensure idempotency of the request.}

\item{id}{[required] The unique identifier of the interface endpoint to update.}

\item{removeSecurityGroupIds}{The unique identifiers of the security groups to remove from the
endpoint.}

\item{removeSubnetIds}{The unique identifiers of the subnets to remove from the endpoint.}
}
\description{
Updates an OpenSearch Serverless-managed interface endpoint. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html}{Access Amazon OpenSearch Serverless using an interface endpoint}.

See \url{https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_vpc_endpoint/} for full documentation.
}
\keyword{internal}
