% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_start_dashboard_snapshot_job}
\alias{quicksight_start_dashboard_snapshot_job}
\title{Starts an asynchronous job that generates a dashboard snapshot}
\usage{
quicksight_start_dashboard_snapshot_job(
  AwsAccountId,
  DashboardId,
  SnapshotJobId,
  UserConfiguration,
  SnapshotConfiguration
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that the dashboard snapshot
job is executed in.}

\item{DashboardId}{[required] The ID of the dashboard that you want to start a snapshot job for.}

\item{SnapshotJobId}{[required] An ID for the dashboard snapshot job. This ID is unique to the dashboard
while the job is running. This ID can be used to poll the status of a
job with a
\code{\link[=quicksight_describe_dashboard_snapshot_job]{describe_dashboard_snapshot_job}}
while the job runs. You can reuse this ID for another job 24 hours after
the current job is completed.}

\item{UserConfiguration}{[required] A structure that contains information about the anonymous users that the
generated snapshot is for. This API will not return information about
registered Amazon QuickSight.}

\item{SnapshotConfiguration}{[required] A structure that describes the configuration of the dashboard snapshot.}
}
\description{
Starts an asynchronous job that generates a dashboard snapshot. You can request one of the following format configurations per API call.

See \url{https://www.paws-r-sdk.com/docs/quicksight_start_dashboard_snapshot_job/} for full documentation.
}
\keyword{internal}
