% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_connection}
\alias{glue_update_connection}
\title{Updates a connection definition in the Data Catalog}
\usage{
glue_update_connection(CatalogId, Name, ConnectionInput)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which the connection resides. If none is
provided, the AWS account ID is used by default.}

\item{Name}{[required] The name of the connection definition to update.}

\item{ConnectionInput}{[required] A \code{ConnectionInput} object that redefines the connection in question.}
}
\description{
Updates a connection definition in the Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$update_connection(
  CatalogId = "string",
  Name = "string",
  ConnectionInput = list(
    Name = "string",
    Description = "string",
    ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA",
    MatchCriteria = list(
      "string"
    ),
    ConnectionProperties = list(
      "string"
    ),
    PhysicalConnectionRequirements = list(
      SubnetId = "string",
      SecurityGroupIdList = list(
        "string"
      ),
      AvailabilityZone = "string"
    )
  )
)
}
}

\keyword{internal}
