% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_user}
\alias{quicksight_update_user}
\title{Updates an Amazon QuickSight user}
\usage{
quicksight_update_user(UserName, AwsAccountId, Namespace, Email, Role)
}
\arguments{
\item{UserName}{[required] The Amazon QuickSight user name that you want to update.}

\item{AwsAccountId}{[required] The ID for the AWS account that the user is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}

\item{Email}{[required] The email address of the user that you want to update.}

\item{Role}{[required] The Amazon QuickSight role of the user. The user role can be one of the
following:
\itemize{
\item \code{READER}: A user who has read-only access to dashboards.
\item \code{AUTHOR}: A user who can create data sources, data sets, analyses,
and dashboards.
\item \code{ADMIN}: A user who is an author, who can also manage Amazon
QuickSight settings.
}}
}
\description{
Updates an Amazon QuickSight user.
}
\details{
The permission resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> }.

The response is a user object that contains the user's Amazon
QuickSight user name, email address, active or inactive status in Amazon
QuickSight, Amazon QuickSight role, and Amazon Resource Name (ARN).

\strong{CLI Sample:}

\code{aws quicksight update-user --user-name=Pat --role=ADMIN --email=new_address@amazon.com --aws-account-id=111122223333 --namespace=default --region=us-east-1 }
}
\section{Request syntax}{
\preformatted{svc$update_user(
  UserName = "string",
  AwsAccountId = "string",
  Namespace = "string",
  Email = "string",
  Role = "ADMIN"|"AUTHOR"|"READER"|"RESTRICTED_AUTHOR"|"RESTRICTED_READER"
)
}
}

\keyword{internal}
