% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_update_cluster_configuration}
\alias{kafka_update_cluster_configuration}
\title{Updates the cluster with the configuration that is specified in the
request body}
\usage{
kafka_update_cluster_configuration(ClusterArn, ConfigurationInfo,
  CurrentVersion)
}
\arguments{
\item{ClusterArn}{[required] The Amazon Resource Name (ARN) that uniquely identifies the cluster.}

\item{ConfigurationInfo}{[required] Represents the configuration that you want MSK to use for the brokers in
a cluster.}

\item{CurrentVersion}{[required] The version of the cluster that needs to be updated.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterArn = "string",
  ClusterOperationArn = "string"
)
}
}
\description{
Updates the cluster with the configuration that is specified in the
request body.
}
\section{Request syntax}{
\preformatted{svc$update_cluster_configuration(
  ClusterArn = "string",
  ConfigurationInfo = list(
    Arn = "string",
    Revision = 123
  ),
  CurrentVersion = "string"
)
}
}

\keyword{internal}
