% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_account_customization}
\alias{quicksight_create_account_customization}
\title{Creates Amazon QuickSight customizations the current AWS Region}
\usage{
quicksight_create_account_customization(AwsAccountId, Namespace,
  AccountCustomization, Tags)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that you want to customize QuickSight for.}

\item{Namespace}{The QuickSight namespace that you want to add customizations to.}

\item{AccountCustomization}{[required] The QuickSight customizations you're adding in the current AWS Region.
You can add these to an AWS account and a QuickSight namespace.

For example, you can add a default theme by setting
\code{AccountCustomization} to the midnight theme:
\verb{"AccountCustomization": \\\{ "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" \\\}}.
Or, you can add a custom theme by specifying
\verb{"AccountCustomization": \\\{ "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" \\\}}.}

\item{Tags}{A list of the tags that you want to attach to this resource.}
}
\description{
Creates Amazon QuickSight customizations the current AWS Region.
Currently, you can add a custom default theme by using the
\code{CreateAccountCustomization} or \code{UpdateAccountCustomization} API
operation. To further customize QuickSight by removing QuickSight sample
assets and videos for all new users, see \href{https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html}{Customizing QuickSight}
in the \emph{Amazon QuickSight User Guide.}

You can create customizations for your AWS account or, if you specify a
namespace, for a QuickSight namespace instead. Customizations that apply
to a namespace always override customizations that apply to an AWS
account. To find out which customizations apply, use the
\code{DescribeAccountCustomization} API operation.

Before you use the \code{CreateAccountCustomization} API operation to add a
theme as the namespace default, make sure that you first share the theme
with the namespace. If you don't share it with the namespace, the theme
isn't visible to your users even if you make it the default theme. To
check if the theme is shared, view the current permissions by using the
\verb{<a>DescribeThemePermissions</a>} API operation. To share the theme,
grant permissions by using the \verb{<a>UpdateThemePermissions</a>} API
operation.
}
\section{Request syntax}{
\preformatted{svc$create_account_customization(
  AwsAccountId = "string",
  Namespace = "string",
  AccountCustomization = list(
    DefaultTheme = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
