% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{standardize_tunnel}
\alias{standardize_tunnel}
\title{Rotate and center a tunnel based on landmarks}
\usage{
standardize_tunnel(
  obj_name,
  landmark_one = "perch1",
  landmark_two = "perch2",
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"} that has been passed
through \code{relabel_viewr_axes()} and \code{gather_tunnel_data()} (or is
structured as though it has been passed through those functions).}

\item{landmark_one}{Subject name of the first landmark}

\item{landmark_two}{Subject name of the second landmark}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which data have
been rotated according to the positions of the landmarks in the data.
}
\description{
Similar to \code{rotate_tunnel()}; rotate and center tunnel data based on
landmarks (specific subjects in the data).
}
\details{
The center point of the tunnel is estimated as the point between the
two landmarks. It is therefore recommended that \code{landmark_one} and
\code{landmark_two} be objects that are placed on opposite ends of the
tunnel (e.g. in an avian flight tunnel, these landmarks may be perches that
are placed at the extreme ends). The angle between landmark_one,
tunnel_center_point, and arbitrary point along the length axis
(tunnel_center_point - 1 on length) is estimated. That angle is then used
to rotate the data, again only in the length and width dimensions. Height
is standardized by average landmark height; values greater than 0 are above
the landmarks and values less than 0 are below the landmark level.
}
\section{Warning}{

The \code{position_length} values of landmark_one MUST be less than
the \code{position_length} values of landmark_two; otherwise,
the rotation will apply to a mirror-image of the tunnel
}

\examples{
## Example data that would work with this function are
## not included in this version of pathviewr. Please
## contact the package authors for further guidance
## should you need it.
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other tunnel standardization functions: 
\code{\link{redefine_tunnel_center}()},
\code{\link{rotate_tunnel}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
\concept{tunnel standardization functions}
