% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize_path}
\alias{standardise_path}
\alias{standardize_path}
\title{Standardize paths}
\usage{
standardize_path(x = dir(), sep = c("/", "\\\\"), include_names = TRUE)

standardise_path(x = dir(), sep = c("/", "\\\\"), include_names = TRUE)
}
\arguments{
\item{x}{A character vector of file paths. Defaults to files in the 
current directory.}

\item{sep}{String separator between directory levels in the output.}

\item{include_names}{A logical value indicating whether the output should be 
named with the input file paths.}
}
\value{
A character vector of paths, pointing to the same locations as the
input, but in a standardized form.
}
\description{
Standardi[sz]e path names so that they can be more easily compared.
}
\details{
\code{standardize_path} wraps \code{\link[base]{normalizePath}},
providing additional tweaks to the output.
\itemize{
\item{Missing inputs always return \code{NA_character_}.}
\item{Leading double back slashes are preserved under all OSes regardless of
the values of \code{sep}.}
\item{Leading double forward slashes are converted to double back slash under
Windows (they are likely UNC paths), and a single forward slash under Unixes
(they are likely absolute paths).}
\item{Other back and forward slashes are replaced by \code{sep}.}
\item{Paths are always made absolute.}
\item{Trailing slashes are always stripped, except for root (\code{"/"}) and
Windows drives (\code{"C:/"}, etc.).}
\item{Windows drives are always capitalized.}
}
}
\examples{
standardize_path(c(".", "..", "~", R.home(), NA))
standardize_path(c(".", "..", "~", R.home(), NA), "\\\\")
}
\seealso{
\code{\link[base]{normalizePath}}, \code{\link[base]{path.expand}},
\code{\link[tools]{file_path_as_absolute}}, \code{\link[R.utils]{getAbsolutePath}}
}

