/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchAlgorithms;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.Subnetwork;
import Application.Parameters;
import Network.Network;
import Network.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class GreedySearch {
    int max_depth;
    int search_depth;
    HashMap<Node, Subnetwork> node2BestComponent;
    double bestScore;
    HashMap<Node, Integer> node2DependentCount;
    HashMap<Node, Node> node2Predecessor;
    boolean greedyDone;
    HashSet<Node> withinMaxDepth;
    ArrayList<Node> nodeList;
    Network graph;

    public ArrayList<Subnetwork> greedySearch() {
        int i;
        this.max_depth = Parameters.gr_maxDepth;
        this.search_depth = Parameters.gr_searchDepth;
        this.node2BestComponent = new HashMap();
        this.nodeList = ActiveSubnetworkSearch.networkNodeList;
        this.graph = ActiveSubnetworkSearch.network;
        int percent = 0;
        for (int nodeNo = 0; nodeNo < this.nodeList.size(); ++nodeNo) {
            Node seed = this.nodeList.get(nodeNo);
            int newPercent = 100 * nodeNo / this.nodeList.size();
            if (newPercent > percent) {
                percent = newPercent;
                System.out.println(percent + "% of seeds checked");
            }
            this.withinMaxDepth = new HashSet();
            if (this.max_depth == 0) {
                for (Node node : this.nodeList) {
                    this.withinMaxDepth.add(node);
                }
            } else {
                this.initializeMaxDepth(seed, this.max_depth);
            }
            ArrayList<Node> nodeListForSubnetwork = new ArrayList<Node>();
            nodeListForSubnetwork.add(seed);
            Subnetwork component = new Subnetwork(nodeListForSubnetwork);
            this.node2DependentCount = new HashMap();
            this.node2Predecessor = new HashMap();
            this.node2DependentCount.put(seed, 1);
            HashSet<Node> removableNodes = new HashSet<Node>();
            this.bestScore = Double.NEGATIVE_INFINITY;
            this.runGreedySearchRecursive(this.search_depth, component, seed, removableNodes);
            this.runGreedyRemovalSearch(component, removableNodes);
            for (Node node : component.getNodeList()) {
                Subnetwork oldBest = this.node2BestComponent.get(node);
                if (oldBest != null && !(oldBest.getScore() < component.getScore())) continue;
                this.node2BestComponent.put(node, component);
            }
        }
        System.out.println("100%");
        ArrayList<Subnetwork> subnetworkList = new ArrayList<Subnetwork>(this.node2BestComponent.values());
        Collections.sort(subnetworkList, Collections.reverseOrder());
        System.out.println("Filtering");
        System.out.println("Subnetwork number" + subnetworkList.size());
        for (i = subnetworkList.size() - 1; i >= 0; --i) {
            if (!(subnetworkList.get(i).getScore() <= 0.0)) continue;
            subnetworkList.remove(i);
        }
        System.out.println("Subnetwork number" + subnetworkList.size());
        for (i = subnetworkList.size() - 1; i >= 0; --i) {
            if (subnetworkList.get(i).numberOfNodes() >= 2) continue;
            subnetworkList.remove(i);
        }
        System.out.println("Subnetwork number" + subnetworkList.size());
        return this.filterSubnetworkList(subnetworkList);
    }

    private ArrayList<Subnetwork> filterSubnetworkList(ArrayList<Subnetwork> subnetworkList) {
        ArrayList<Subnetwork> filteredSubnetworkList = new ArrayList<Subnetwork>();
        ArrayList<Subnetwork> subnetworkListToBeDeleted = new ArrayList<Subnetwork>();
        int percent = 0;
        for (int i = 0; i < subnetworkList.size() - 1 && (double)filteredSubnetworkList.size() < Parameters.gr_subnetworkNum; ++i) {
            Subnetwork subnetwork1;
            int newPercent = 100 * i / subnetworkList.size();
            if (newPercent > percent) {
                percent = newPercent;
                System.out.println(percent + "% of subnetworks checked, " + (filteredSubnetworkList.size() + 1) + " filtered subnetworks in the list");
            }
            if (subnetworkListToBeDeleted.contains(subnetwork1 = subnetworkList.get(i))) continue;
            filteredSubnetworkList.add(subnetwork1);
            for (int j = i + 1; j < subnetworkList.size(); ++j) {
                Subnetwork subnetwork2 = subnetworkList.get(j);
                if (subnetworkListToBeDeleted.contains(subnetwork2)) continue;
                int common = 0;
                for (Node node1 : subnetwork1.getNodeList()) {
                    if (!subnetwork2.contains(node1)) continue;
                    ++common;
                }
                int size = subnetwork1.numberOfNodes() < subnetwork2.numberOfNodes() ? subnetwork1.numberOfNodes() : subnetwork2.numberOfNodes();
                double overlap = (double)common / (double)size;
                if (!(overlap > Parameters.gr_overlapThreshold)) continue;
                subnetworkListToBeDeleted.add(subnetwork2);
            }
        }
        System.out.println("100%");
        return filteredSubnetworkList;
    }

    private void initializeMaxDepth(Node current, int depth) {
        this.withinMaxDepth.add(current);
        if (depth > 0) {
            for (Node neighbor : this.graph.getNeighborSet(current)) {
                if (this.withinMaxDepth.contains(neighbor)) continue;
                this.initializeMaxDepth(neighbor, depth - 1);
            }
        }
    }

    private boolean runGreedySearchRecursive(int depth, Subnetwork component, Node lastAdded, HashSet<Node> removableNodes) {
        boolean improved = false;
        if (component.getScore() > this.bestScore) {
            depth = this.search_depth;
            improved = true;
            this.bestScore = component.getScore();
        }
        if (depth > 0) {
            boolean anyCallImproved = false;
            removableNodes.remove(lastAdded);
            int dependentCount = 0;
            for (Node newNeighbor : this.graph.getNeighborSet(lastAdded)) {
                if (!this.withinMaxDepth.contains(newNeighbor) || component.contains(newNeighbor)) continue;
                component.addNode(newNeighbor);
                removableNodes.add(newNeighbor);
                boolean thisCallImproved = this.runGreedySearchRecursive(depth - 1, component, newNeighbor, removableNodes);
                if (!thisCallImproved) {
                    component.removeNode(newNeighbor);
                    removableNodes.remove(newNeighbor);
                    continue;
                }
                ++dependentCount;
                anyCallImproved = true;
                this.node2Predecessor.put(newNeighbor, lastAdded);
            }
            improved |= anyCallImproved;
            if (dependentCount > 0) {
                removableNodes.remove(lastAdded);
                this.node2DependentCount.put(lastAdded, dependentCount);
            }
        }
        return improved;
    }

    private void runGreedyRemovalSearch(Subnetwork component, HashSet removableNodes) {
        LinkedList list = new LinkedList(removableNodes);
        while (!list.isEmpty()) {
            Node current = (Node)list.removeFirst();
            component.removeNode(current);
            double score = component.getScore();
            if (score > this.bestScore) {
                this.bestScore = score;
                Node predecessor = this.node2Predecessor.get(current);
                int dependentCount = this.node2DependentCount.get(predecessor);
                if (--dependentCount == 0) {
                    removableNodes.add(predecessor);
                    continue;
                }
                this.node2DependentCount.put(predecessor, dependentCount);
                continue;
            }
            component.addNode(current);
        }
    }
}

