% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{plot_scores}
\alias{plot_scores}
\title{Plot the Heatmap of Pathway Scores}
\usage{
plot_scores(score_matrix, cases = NULL)
}
\arguments{
\item{score_matrix}{Matrix of pathway scores per sample. Columns are
samples, rows are pathways.}

\item{cases}{(Optional) A vector of sample names that are cases in the
case/control experiment.}
}
\value{
A `ggplot2` object containing the heatmap plot. x-axis indicates
the samples. y-axis indicates the pathways. "Pathway Score" indicates the
pathway score of a sample. If `cases` are provided, the plot is divided
into 2 facets: "Case" and "Control".
}
\description{
Plot the Heatmap of Pathway Scores
}
\examples{
score_mat <- calculate_pw_scores(RA_output, RA_exp_mat, plot_hmap = FALSE)
hmap <- plot_scores(score_mat)
}
