/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchAlgorithms;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.Subnetwork;
import Network.Node;
import Network.SubnetworkFinder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class GAIndividual
implements Comparable<Object> {
    private ArrayList<Boolean> representationBoolean;
    private ArrayList<Node> networkNodeList;
    private HashSet<Node> nodesOnSet;
    private ArrayList<Subnetwork> subnetworkList;

    public GAIndividual(HashSet<Node> nodesOnSet) {
        this.nodesOnSet = nodesOnSet;
        this.networkNodeList = ActiveSubnetworkSearch.networkNodeList;
        this.representationBoolean = new ArrayList();
        for (Node node : this.networkNodeList) {
            if (nodesOnSet.contains(node)) {
                this.representationBoolean.add(Boolean.TRUE);
                continue;
            }
            this.representationBoolean.add(Boolean.FALSE);
        }
        this.subnetworkList = new SubnetworkFinder().findSubnetworksDFS(nodesOnSet);
        Collections.sort(this.subnetworkList, Collections.reverseOrder());
    }

    public GAIndividual(ArrayList<Boolean> representationBoolean) {
        this.representationBoolean = representationBoolean;
        this.networkNodeList = ActiveSubnetworkSearch.networkNodeList;
        this.nodesOnSet = new HashSet();
        for (int i = 0; i < representationBoolean.size(); ++i) {
            if (!representationBoolean.get(i).booleanValue()) continue;
            this.nodesOnSet.add(this.networkNodeList.get(i));
        }
        this.subnetworkList = new SubnetworkFinder().findSubnetworksDFS(this.nodesOnSet);
        Collections.sort(this.subnetworkList, Collections.reverseOrder());
    }

    @Override
    public int compareTo(Object o) {
        int result = 0;
        boolean decision = false;
        Iterator<Subnetwork> ownIt = this.subnetworkList.iterator();
        Iterator<Subnetwork> otherIt = ((GAIndividual)o).getSubnetworkList().iterator();
        while (!decision && ownIt.hasNext() && otherIt.hasNext()) {
            Subnetwork subnetworkOwn = ownIt.next();
            Subnetwork subnetworkOther = otherIt.next();
            if (subnetworkOwn.getScore() > subnetworkOther.getScore()) {
                result = 1;
                decision = true;
                continue;
            }
            if (!(subnetworkOwn.getScore() < subnetworkOther.getScore())) continue;
            result = -1;
            decision = true;
        }
        return result;
    }

    public ArrayList<Boolean> getRepresentationBoolean() {
        return this.representationBoolean;
    }

    public ArrayList<Node> getNetworkNodeList() {
        return this.networkNodeList;
    }

    public HashSet<Node> getNodesOnSet() {
        return this.nodesOnSet;
    }

    public ArrayList<Subnetwork> getSubnetworkList() {
        return this.subnetworkList;
    }

    public Subnetwork getHighestScoringSubnetwork() {
        return this.subnetworkList.get(0);
    }

    public double getScore() {
        if (this.subnetworkList.isEmpty()) {
            return 0.0;
        }
        return this.subnetworkList.get(0).getScore();
    }

    public String toString() {
        String str = "";
        for (Subnetwork subnetwork : this.subnetworkList) {
            if (subnetwork.numberOfNodes() <= 1) continue;
            str = str + subnetwork.numberOfNodes() + " ";
            str = str + new DecimalFormat("###.##").format(subnetwork.getScore()) + ", ";
        }
        return str;
    }
}

