#' Extract data frame from a region slice
#'
#' Extract the climatic information from a region slice and organise it as
#' a data frame. This is just a wrapper around [terra::as.data.frame()].
#' 
#' To extract a data frame from a region series, see [df_from_region_series()].
#'
#' @param x climate time slice (i.e. a [`terra::SpatRaster`]) 
#' generated with [region_slice()]
#' @param xy a boolean whether x and y coordinates should be added 
#' to the dataframe (default to TRUE)
#' @returns a data.frame where each cell the raster is a
#' row, and the available variables are columns.
#'
#' @export

df_from_region_slice <- function(x ,xy=TRUE) {
  if (!inherits(x,"SpatRaster")){
    stop("x is not a valid SpatRaster generated by region_slice")
  }
  slice_df <- terra::as.data.frame(x,xy=xy)
  return(slice_df)
}
