% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{pearson}
\alias{pearson}
\alias{pearson,Partition,Partition-method}
\alias{pearson,PairCoefficients,missing-method}
\title{Pearson Index}
\usage{
pearson(p, q)

\S4method{pearson}{Partition,Partition}(p, q)

\S4method{pearson}{PairCoefficients,missing}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Pearson index
\deqn{\frac{N_{11}N_{00} - N_{10}N_{01}}{N_{21}N_{12}N'_{01}N'_{10}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(pearson(new("Partition", c(0, 0, 0, 1, 1)), 
                         new("Partition", c(0, 0, 1, 1, 1))), 1/144))

}
\references{
\insertRef{Pearson1926}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
