% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_rad.R
\encoding{UTF-8}
\name{convert_rad}
\alias{convert_rad}
\title{Extracts information from radiological notes free text.}
\usage{
convert_rad(
  d,
  code = "rad_rep_txt",
  anchors = c("Exam Code", "Ordering Provider", "HISTORY", "Associated Reports",
    "Report Below", "REASON", "REPORT", "TECHNIQUE", "COMPARISON", "FINDINGS",
    "IMPRESSION", "RECOMMENDATION", "SIGNATURES", "report_end"),
  nThread = 4
)
}
\arguments{
\item{d}{data.table, database containing radiological notes loaded using the \emph{load_rad} function.}

\item{code}{string vector, column name containing the results. Defaults to: \emph{"rad_rep_txt"}.}

\item{anchors}{string array, elements to search for in the text report. Defaults to common standard elements, but may be extended to include additional phrases i.e. "CAD-RADS".}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.
On windows machines sockets are used, while on other operating systems fork parallelization is used.}
}
\value{
data.table, with new columns corresponding to elements in \emph{anchors}.
}
\description{
Analyzes radiological notes loaded using \emph{load_rad}. Extracts information from the free text present in \emph{rad_rep_txt}.
An array of string is provided using the \emph{anchors} argument. The function will return as many columns as there are anchor points.
Each column will contain the text between the given anchor point and the next following anchor point.
This way the free text report is split into corresponding smaller texts. By default, these are the common standard elements of the radiological report,
however they may be extended to include sections of interest, i.e. if a given score is reported standardly, then adding this phrase (i.e. "CAD-RADS")
would create a column where the text following this statement is returned. After this the resulting columns can be easily cleaned up if needed.
Be aware to always include \emph{"report_end"} in the anchors array, to provide the function of the last occurring statement in the report.
}
\examples{
\dontrun{
#Create columns with specific parts of the radiological report defined by anchors
data_rad_parsed <- convert_rad(d = data_rad, nThread = 2)
}
}
