% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{match_s}
\alias{match_s}
\title{Identifying and processing a string and producing custom output}
\usage{
match_s(s)
}
\arguments{
\item{s}{a string-parsing function.}
}
\value{
A parser.
}
\description{
\code{match_s} matches a string using a function and returns a desired object
type.
}
\details{
This parser short-cuts the pattern \code{satisfy(b) \%using\% f}. With \code{match_s}
you do not have to write separate predicate and processing functions \code{b} and
\code{f} when identification and parsing can be done with a single string
parsing function \code{s}.

The function \code{s} will be given a non-empty single-element character vector
as its argument, so you don't have to test for empty input, like
\code{character(0)}. These two facts also often simplify further processing with
the string functions like \code{grep}, \code{regmatches} and those from the \code{stringr}
package. The function \code{s} can return any R-object when succeeding, but to
signal failure to the parser it must return the empty \code{list()}. Note that
\code{list()} output from \code{s} will be turned into a marker object, the internal
object to mark failure, by \code{match_s()}, see \code{\link[=failed]{failed()}}.
}
\section{Pseudocode}{

\preformatted{
match_s(s)(x):
  if x==null then fail()(x)
  else if s(x[1]) then succeed(s(x[1]))(x[-1]) else fail()(x)
}
}

\examples{
expect_integers <- function(x) {
  m <- gregexpr("[[:digit:]]+", x)
  matches <- regmatches(x, m)[[1]]
  if (length(matches) == 0) {
    # this means failure to detect numbers where we expected them
    return(list())
  } else {
    return(as.numeric(matches))
  }
}

match_s(expect_integers)("12 15 16 # some comment") # success
match_s(expect_integers)("some text") # failure

}
