% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_odds_to_d.R
\name{odds_to_d}
\alias{odds_to_d}
\alias{convert_odds_to_d}
\alias{d_to_odds}
\alias{convert_d_to_odds}
\title{Conversion between (log)odds and standardized difference}
\usage{
odds_to_d(odds, log = FALSE)

convert_odds_to_d(odds, log = FALSE)

d_to_odds(d, log = FALSE)

convert_d_to_odds(d, log = FALSE)
}
\arguments{
\item{odds}{Odds values in vector or dataframe.}

\item{log}{Are these Log odds (such as in logistic models)?}

\item{d}{standardized difference values in vector or dataframe.}
}
\value{
Converted index.
}
\description{
Enables a conversion between (log)odds and standardized difference using Cohen's (1988) formula \eqn{\frac{\log(odds)\times\sqrt{3}}{\pi}}.
}
\examples{
odds_to_d(0.2)
odds_to_d(-1.45, log = TRUE)
}
\references{
\itemize{
  \item Sánchez-Meca, J., Marín-Martínez, F., & Chacón-Moscoso, S. (2003). Effect-size indices for dichotomized outcomes in meta-analysis. Psychological methods, 8(4), 448.
  \item Borenstein, Michael, et al. "Converting among effect sizes." Introduction to meta-analysis (2009): 45-49.
}
}
