% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_PMCMRplus.R, R/methods_multcomp.R
\name{model_parameters.PMCMR}
\alias{model_parameters.PMCMR}
\alias{model_parameters.glht}
\title{Parameters from Hypothesis Testing}
\usage{
\method{model_parameters}{PMCMR}(model, ...)

\method{model_parameters}{glht}(model, ci = 0.95, exponentiate = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{model}{Object of class \code{\link[multcomp:glht]{multcomp::glht()}} (\strong{multcomp})
or of class \code{PMCMR}, \code{trendPMCMR} or \code{osrt} (\strong{PMCMRplus}).}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are
passed down to \code{bootstrap_model()}, and arguments like \code{ci_method}
are passed down to \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from Hypothesis Testing.
}
\examples{
\donttest{
if (require("multcomp", quietly = TRUE)) {
  # multiple linear model, swiss data
  lmod <- lm(Fertility ~ ., data = swiss)
  mod <- glht(
    model = lmod,
    linfct = c(
      "Agriculture = 0",
      "Examination = 0",
      "Education = 0",
      "Catholic = 0",
      "Infant.Mortality = 0"
    )
  )
  model_parameters(mod)
}
if (require("PMCMRplus", quietly = TRUE)) {
  model <- kwAllPairsConoverTest(count ~ spray, data = InsectSprays)
  model_parameters(model)
}
}
}
