% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_parameters.R
\name{model_parameters}
\alias{model_parameters}
\alias{parameters}
\title{Model Parameters}
\usage{
model_parameters(model, ...)

parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented
arguments are \code{digits}, \code{p_digits}, \code{ci_digits} and
\code{footer_digits} to set the number of digits for the output.
\code{group} can also be passed to the \code{print()} method. See details
in \code{\link{print.parameters_model}} and 'Examples' in
\code{\link{model_parameters.default}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Compute and extract model parameters. See the documentation for your object's class:
\itemize{
 \item{\link[=model_parameters.htest]{Correlations, t-tests, ...} (\code{htest}, \code{pairwise.htest})}
 \item{\link[=model_parameters.aov]{ANOVAs} (\code{aov}, \code{anova}, \pkg{afex}, ...)}
 \item{\link[=model_parameters.default]{Regression models} (\code{lm}, \code{glm}, \pkg{survey}, ...)}
 \item{\link[=model_parameters.cgam]{Additive models} (\code{gam}, \code{gamm}, ...)}
 \item{\link[=model_parameters.zcpglm]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount})}
 \item{\link[=model_parameters.mlm]{Multinomial, ordinal and cumulative link models} (\code{bracl}, \code{multinom}, \code{mlm}, ...)}
 \item{\link[=model_parameters.averaging]{Other special models} (\code{model.avg}, \code{betareg}, \code{glmx}, ...)}
 \item{\link[=model_parameters.merMod]{Mixed models} (\pkg{lme4}, \pkg{nlme}, \pkg{glmmTMB}, \pkg{afex}, ...)}
 \item{\link[=model_parameters.BFBayesFactor]{Bayesian tests} (\pkg{BayesFactor})}
 \item{\link[=model_parameters.stanreg]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, \pkg{blavaan}, ...)}
 \item{\link[=model_parameters.principal]{PCA and FA} (\pkg{psych})}
 \item{\link[=model_parameters.lavaan]{CFA and SEM} (\pkg{lavaan})}
 \item{\link[=model_parameters.kmeans]{Cluster models} (k-means, ...)}
 \item{\link[=model_parameters.rma]{Meta-Analysis via linear (mixed) models} (\code{rma}, \code{metaplus}, \pkg{metaBMA}, ...)}
 \item{\link[=model_parameters.glht]{Hypothesis testing} (\code{glht}, \pkg{PMCMRplus})}
 \item{\link[=model_parameters.t1way]{Robust statistical tests} (\pkg{WRS2})}
 \item{\link[=model_parameters.mira]{Multiply imputed repeated analyses} (\code{mira})}
 }
}
\details{
\subsection{Standardization of model coefficients}{
  Standardization is based on \code{\link[effectsize:standardize_parameters]{standardize_parameters()}}.
  In case of \code{standardize = "refit"}, the data used to fit the model
  will be standardized and the model is completely refitted. In such cases,
  standard errors and confidence intervals refer to the standardized
  coefficient. The default, \code{standardize = "refit"}, never standardizes
  categorical predictors (i.e. factors), which may be a different behaviour
  compared to other R packages or other software packages (like SPSS).
  To mimic behaviour of SPSS or packages such as \pkg{lm.beta}, use
  \code{standardize = "basic"}.
  }
\subsection{Methods of standardization}{
  For full details, please refer to \code{\link[effectsize:standardize_parameters]{standardize_parameters()}}.
  \describe{
    \item{\strong{refit}}{
      This method is based on a complete model re-fit with a standardized version
      of the data. Hence, this method is equal to standardizing the variables
      before fitting the model. It is the "purest" and the most accurate
      (Neter et al., 1989), but it is also the most computationally costly and
      long (especially for heavy models such as Bayesian models).The
      \code{robust} argument (default to \code{FALSE}) enables a robust standardization
      of data, i.e., based on the \code{median} and \code{MAD} instead of the
      \code{mean} and \code{SD}.
    }
    \item{\strong{posthoc}}{
      Post-hoc standardization of the parameters, aiming at emulating the
      results obtained by \code{"refit"} without refitting the model. The coefficients
      are divided by the standard deviation (or MAD if \code{robust=TRUE}) of
      the outcome (which becomes their expression 'unit'). Then, the coefficients
      related to numeric variables are additionally multiplied by the standard
      deviation (or MAD) of the related terms, so that they correspond to
      changes of 1 SD of the predictor. This does not apply to binary
      variables or factors, so the coefficients are still related to changes in
      levels. This method is not accurate and tend to give aberrant results when
      interactions are specified.
    }
    \item{\strong{smart}}{
      (Standardization of Model's parameters with Adjustment, Reconnaissance
      and Transformation - \emph{experimental}): Similar to \code{method="posthoc"}
      in that it does not involve model refitting. The difference is that the
      SD (or MAD) of the response is computed on the relevant section of the
      data. For instance, if a factor with 3 levels A (the intercept), B and C
      is entered as a predictor, the effect corresponding to B vs. A will be
      scaled by the variance of the response at the intercept only. As a results,
      the coefficients for effects of factors are similar to a Glass' delta.
    }
    \item{\strong{basic}}{
      This method is similar to \code{method="posthoc"}, but treats all
      variables as continuous: it also scales the coefficient by the standard
      deviation of model's matrix' parameter of factors levels (transformed to
      integers) or binary predictors. Although being inappropriate for these cases,
      this method is the one implemented by default in other software packages,
      such as \code{lm.beta::lm.beta()}.
    }
    \item{\strong{pseudo} (\emph{for 2-level (G)LMMs only})}{
      In this (post-hoc) method, the response and the predictor are standardized
      based on the level of prediction (levels are detected with \code{\link{check_heterogeneity}}:
      Predictors are standardized based on their SD at level of prediction
      (see also \code{\link{demean}}). The outcome (in linear LMMs) is
      standardized based on a fitted random-intercept-model, where
      \code{sqrt(random-intercept-variance)} is used for level 2 predictors,
      and \code{sqrt(residual-variance)} is used for level 1 predictors
      (Hoffman 2015, page 342). A warning is given when a within-group variable
      is found to have access between-group variance.
    }
  }
}
}
\note{
The \code{\link[=print.parameters_model]{print()}} method has several
  arguments to tweak the output. There is also a
  \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method}
  implemented in the
  \href{https://easystats.github.io/see/}{\pkg{see}-package}, and a dedicated
  method for use inside rmarkdown files,
  \code{\link[=print_md.parameters_model]{print_md()}}.
}
\section{Labeling the Degrees of Freedom}{

Throughout the \pkg{parameters} package, we decided to label the residual
degrees of freedom \emph{df_error}. The reason for this is that these degrees
of freedom not always refer to the residuals. For certain models, they refer
to the estimate error - in a linear model these are the same, but in - for
instance - any mixed effects model, this isn't strictly true. Hence, we
think that \code{df_error} is the most generic label for these degrees of
freedom.
}

\section{Interpretation of Interaction Terms}{

Note that the \emph{interpretation} of interaction terms depends on many
characteristics of the model. The number of parameters, and overall
performance of the model, can differ \emph{or not} between \code{a * b}
\code{a : b}, and \code{a / b}, suggesting that sometimes interaction terms
give different parameterizations of the same model, but other times it gives
completely different models (depending on \code{a} or \code{b} being factors
of covariates, included as main effects or not, etc.). Their interpretation
depends of the full context of the model, which should not be inferred
from the parameters table alone - rather, we recommend to use packages
that calculate estimated marginal means or marginal effects, such as
\CRANpkg{modelbased}, \CRANpkg{emmeans} or \CRANpkg{ggeffects}. To raise
awareness for this issue, you may use \code{print(...,show_formula=TRUE)}
to add the model-specification to the output of the
\code{\link[=print.parameters_model]{print()}} method for \code{model_parameters()}.
}

\references{
\itemize{
  \item Hoffman, L. (2015). Longitudinal analysis: Modeling within-person fluctuation and change. Routledge.
  \item Neter, J., Wasserman, W., & Kutner, M. H. (1989). Applied linear regression models.
}
}
\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to
  rename columns into a consistent, standardized naming scheme.
}
