% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamSet.R
\docType{data}
\name{ParamSet}
\alias{ParamSet}
\title{ParamSet}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
ParamSet
}
\description{
A set of \link{Param} objects.
Please note that when creating a set or adding to it, the parameters of the
resulting set have to be uniquely named with IDs with valid R names.
The set also contains a member variable \code{values} which can be used to store an active configuration / or to partially fix
some parameters to constant values (regarding subsequent sampling or generation of designs).
}
\section{Construction}{
\preformatted{ParamSet$new(params = named_list())
}
\itemize{
\item \code{params} :: named \code{list()}\cr
List of \link{Param}, named with their respective ID.
Parameters are cloned.
}
}

\section{Fields}{

\itemize{
\item \code{set_id} :: \code{character(1)} \cr
ID of this param set. Default \code{""}. Settable.
\item \code{length} :: \code{integer(1)} \cr
Number of contained \link{Param}s.
\item \code{is_empty} :: \code{logical(1)} \cr
Is the \code{ParamSet} empty?
\item \code{class} :: named \code{character()} \cr
Classes of contained parameters, named with parameter IDs.
\item \code{lower} :: named \code{double()} \cr
Lower bounds of parameters (\code{NA} if parameter is not numeric).
Named with parameter IDs.
\item \code{upper} :: named \code{double()} \cr
Upper bounds of parameters (\code{NA} if parameter is not numeric).
Named with parameter IDs.
\item \code{levels} :: named \code{list()} \cr
List of character vectors of allowed categorical values of contained parameters.
\code{NULL} if the parameter is not categorical.
Named with parameter IDs.
\item \code{nlevels} :: named \code{integer()} \cr
Number of categorical levels per parameter, \code{Inf} for double parameters or unbounded integer parameters.
Named with param IDs.
\item \code{is_bounded} :: named \code{logical(1)} \cr
Do all parameters have finite bounds?
Named with parameter IDs.
\item \code{special_vals} :: named \code{list()} of \code{list()} \cr
Special values for all parameters.
Named with parameter IDs.
\item \code{storage_type} :: \code{character()} \cr
Data types of parameters when stored in tables.
Named with parameter IDs.
\item \code{tags} :: named \code{list()} of \code{character()} \cr
Can be used to group and subset parameters.
Named with parameter IDs.
\item \code{default} :: named \code{list()} \cr
Default values of all parameters.
If no default exists, element is not present.
Named with parameter IDs.
\item is_number :: named \code{logical()} \cr
Position is TRUE for \link{ParamDbl} and \link{ParamInt}.
Named with parameter IDs.
\item is_categ          :: named \code{logical} \cr
Position is TRUE for \link{ParamFct} and \link{ParamLgl}.
Named with parameter IDs.
\item \code{has_deps} :: \code{logical(1)} \cr
Has the set parameter dependencies?
\item \code{deps} :: \code{\link[data.table:data.table]{data.table::data.table()}} \cr
Table has cols \code{id} (\code{character(1)}) and \code{on} (\code{character(1)}) and \code{cond} (\link{Condition}).
Lists all (direct) dependency parents of a param, through parameter IDs.
Internally created by a call to \code{add_dep}.
Settable, if you want to remove dependencies or perform other changes.
\item \code{values}         :: named \code{list()} \cr
Currently set / fixed parameter values.
Settable, and feasibility of values will be checked when you set them.
You do not have to set values for all parameters, but only for a subset.
When you set values, all previously set values will be unset / removed.
\item \code{trafo} :: \code{function(x, param_set)}\cr
Transformation function. Settable.
User has to pass a \code{function(x, param_set)}, of the form \cr
(named \code{list()}, \link{ParamSet}) -> named \code{list()}.\cr
The function is responsible to transform a feasible configuration into another encoding, before potentially evaluating the configuration with the target algorithm.
For the output, not many things have to hold.
It needs to have unique names, and the target algorithm has to accept the configuration.
For convenience, the self-paramset is also passed in, if you need some info from it (e.g. tags).
Is NULL by default, and you can set it to NULL to switch the transformation off.
\item \code{has_trafo} :: \code{logical(1)} \cr
Has the set a \code{trafo} function?
}
}

\section{Public methods}{

\itemize{
\item \code{ids(class = NULL, is_bounded = NULL, tags = NULL)} \cr
(\code{character}, \code{logical(1)}, \code{character()}) -> \code{character()} \cr
Retrieves IDs of contained parameters based on some filter criteria selections, \code{NULL} means no restriction.
\item \code{get_values(class = NULL, is_bounded = NULL, tags = NULL)} \cr
(\code{character()}, \code{logical(1)}, \code{character()}) -> named \code{list()} \cr
Retrieves parameter values based on some selections, \code{NULL} means no restriction and is
equivalent to \code{$values}.
\item \code{add(param_set)} \cr
(\link{Param} | \link{ParamSet}) -> \code{self} \cr
Adds a single param or another set to this set, all params are cloned.
\item \code{subset(ids)} \cr
\code{character()} -> \code{self} \cr
Changes the current set to the set of passed IDs.
\item \code{test(x)}, \code{check(x)}, \code{assert(x)} \cr
Three \pkg{checkmate}-like check-functions. Takes a named list.
A point x is feasible, if it configures a subset of params,
all individual param constraints are satisfied and all dependencies are satisfied.
Params for which dependencies are not satisfied should not be part of \code{x}.
\item \code{add_dep(id, on, cond)} \cr
(\code{character(1)}, \code{character(1)}, \link{Condition}) -> \code{self} \cr
Adds a dependency to this set, so that param \code{id} now depends on param \code{on}.
}
}

\section{S3 methods and type converters}{

\itemize{
\item \code{as.data.table()} \cr
Compact representation as datatable. Col types are: \cr
\itemize{
\item id: character
\item lower, upper: double
\item levels: list col, with NULL elements
\item special_vals: list col of list
\item is_bounded: logical
\item default: list col, with NULL elements
\item storage_type: character
\item tags: list col of character vectors
}
}
}

\examples{
ps = ParamSet$new(
  params = list(
    ParamDbl$new("d", lower = -5, upper = 5, default = 0),
    ParamFct$new("f", levels = letters[1:3])
  )
)

ps$trafo = function(x, param_set) {
  x$d = 2^d
  return(x)
}

ps$add(ParamInt$new("i", lower = 0L, upper = 16L))

ps$check(list(d = 2.1, f = "a", i = 3L))

}
\keyword{datasets}
