% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exception.R
\name{Exception}
\alias{Exception}
\title{Package Exceptions}
\format{
\describe{
\item{\code{Exception$abstract_class_not_instantiable()}}{Exception for instantiating abstract classes or interfaces.}
\item{\code{Exception$method_not_implemented()}}{Exception for calling methods without an implementation.}
\item{\code{Exception$feature_not_developed()}}{Exception for running into things not yet developed.}
\item{\code{Exception$not_enough_cores()}}{Exception for requesting more cores than available on the machine.}
\item{\code{Exception$cluster_active()}}{Exception for attempting to start a cluster while another one is active.}
\item{\code{Exception$cluster_not_active()}}{Exception for attempting to stop a cluster while not active.}
\item{\code{Exception$async_task_not_started()}}{Exception for reading results while an asynchronous task has not yet started.}
\item{\code{Exception$async_task_running()}}{Exception for reading results while an asynchronous task is running.}
\item{\code{Exception$async_task_completed()}}{Exception for reading results while a completed asynchronous task has unread results.}
\item{\code{Exception$temporary_file_creation_failed()}}{Exception for reading results while an asynchronous task is running.}
\item{\code{Exception$type_not_assignable()}}{Exception for when providing incorrect object types.}
\item{\code{Exception$unknown_package_option()}}{Exception for when requesting unknown package options.}
}
}
\description{
This class contains static methods for throwing exceptions with informative
messages.
}

