% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backend.R
\name{Backend}
\alias{Backend}
\title{Backend}
\description{
This is an abstract class that serves as a base class for all concrete
backend implementations. It defines the common properties that all concrete
backends require.
}
\details{
This class cannot be instantiated. It needs to be extended by concrete
subclasses that implement the pure virtual methods. Instances of concrete
backend implementations can be conveniently obtained using the
\code{\link{BackendFactory}} class.
}
\seealso{
\code{\link{Service}}, \code{\link{SyncBackend}}, \code{\link{AsyncBackend}},
\code{\link{BackendFactory}}, and \code{\link{Context}}.
}
\section{Super class}{
\code{\link[parabar:Service]{parabar::Service}} -> \code{Backend}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{cluster}}{The cluster object used by the backend. For
\code{\link{SyncBackend}} objects, this is a cluster object created by
\code{\link[parallel:makeCluster]{parallel::makeCluster()}}. For \code{\link{AsyncBackend}} objects,
this is a permanent \code{R} session created by \code{\link[callr:r_session]{callr::r_session}} that
contains the \code{\link[parallel:makeCluster]{parallel::makeCluster()}} cluster object.}

\item{\code{supports_progress}}{A boolean value indicating whether the
backend implementation supports progress tracking.}

\item{\code{active}}{A boolean value indicating whether the backend
implementation has an active cluster.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Backend-new}{\code{Backend$new()}}
\item \href{#method-Backend-clone}{\code{Backend$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="clear"><a href='../../parabar/html/Service.html#method-Service-clear'><code>parabar::Service$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="evaluate"><a href='../../parabar/html/Service.html#method-Service-evaluate'><code>parabar::Service$evaluate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="export"><a href='../../parabar/html/Service.html#method-Service-export'><code>parabar::Service$export()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="get_output"><a href='../../parabar/html/Service.html#method-Service-get_output'><code>parabar::Service$get_output()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="peek"><a href='../../parabar/html/Service.html#method-Service-peek'><code>parabar::Service$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="sapply"><a href='../../parabar/html/Service.html#method-Service-sapply'><code>parabar::Service$sapply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="start"><a href='../../parabar/html/Service.html#method-Service-start'><code>parabar::Service$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Service" data-id="stop"><a href='../../parabar/html/Service.html#method-Service-stop'><code>parabar::Service$stop()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Backend-new"></a>}}
\if{latex}{\out{\hypertarget{method-Backend-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{Backend}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Backend$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Instantiating this call will throw an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Backend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Backend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Backend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
