% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_defunct.R
\name{render_appendix}
\alias{render_appendix}
\title{Render Appendix}
\usage{
render_appendix(
  x,
  bibliography = rmarkdown::metadata$bibliography,
  csl = rmarkdown::metadata$csl,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{x}{Character. Path to R Markdown file.}

\item{bibliography}{Character. Paths to relevant bibliography file(s).}

\item{csl}{Character. Path to CSL file to use. Defaults to APA-style.}

\item{quiet}{Logical. Suppresses pandoc command line output; see \code{\link[rmarkdown]{render}}.
If \code{FALSE} output will be included in the document.}

\item{...}{
  Arguments passed on to \code{\link[rmarkdown:pandoc_convert]{rmarkdown::pandoc_convert}}
  \describe{
    \item{\code{input}}{Character vector containing paths to input files
(files must be UTF-8 encoded)}
    \item{\code{to}}{Format to convert to (if not specified, you must specify
\code{output})}
    \item{\code{from}}{Format to convert from (if not specified then the format is
determined based on the file extension of \code{input}).}
    \item{\code{output}}{Output file (if not specified then determined based on format
being converted to).}
    \item{\code{citeproc}}{\code{TRUE} to run the pandoc-citeproc filter (for processing
citations) as part of the conversion.}
    \item{\code{options}}{Character vector of command line options to pass to pandoc.}
    \item{\code{verbose}}{\code{TRUE} to show the pandoc command line which was executed}
    \item{\code{wd}}{Working directory in which code will be executed. If not
supplied, defaults to the common base directory of \code{input}.}
  }}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
This function renders an R Markdown document \emph{without} YAML header to a TeX
fragment inside an \code{appendix} environment, or to a markdown fragment (for
Word output). \emph{This function has been defunct. Please use the appendix
syntax provided by \pkg{bookdown} (see the \href{https://bookdown.org/yihui/bookdown/markdown-extensions-by-bookdown.html#special-headers}{bookdown manual}).}
}
\details{
\strong{This function is only exported for backwards compatibility.}
It is now recommended \emph{not} to call \code{render_appendix()} directly.
Instead, to add appendices to your manuscript, add the R Markdown file
to the YAML front matter by using \code{appendix: "appendix.Rmd"}.

Default chunk options and hooks are set to those used in the R Markdown
document from which \code{render_appendix} is called; otherwise defaults of
\code{\link[rmarkdown]{md_document}} are used.

By default, \code{x} is converted to a TeX file, which can be included in an
R Markdown document as \code{include}:

\preformatted{
  output:
    pdf_document:
      include:
        after_body: appendix.tex
  }

If \code{render_appendix} is called form an R Markdown document with a
target document type other than a PDF file, a markdown fragment is
included.
}
\keyword{internal}
