% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment.R
\name{nemoment}
\alias{nemoment}
\title{The naive estimation of the moments}
\usage{
nemoment(data, acov_order = 0, acor_order = 1, R = 1000)
}
\arguments{
\item{data}{A matrix of panel data.
Each row corresponds to individual time series.}

\item{acov_order}{A non-negative integer of the order of autocovariance.
Default is 0.}

\item{acor_order}{A positive integer of the order of autocorrelation
Default is 1.}

\item{R}{A positive integer of the number of bootstrap repetitions.
Default is 1000.}
}
\value{
A list that contains the following elements.
\item{estimate}{A vector of the parameter estimates}
\item{se}{A vector of the standard errors}
\item{ci}{A matrix of the 95 percent confidence intervals}
\item{quantity}{A matrix of the estimated heterogeneous quantities}
\item{acov_order}{The order of autocovariance}
\item{acor_order}{The order of autocovariance}
\item{N}{The number of cross-sectional units}
\item{S}{The length of time series}
\item{R}{The number of bootstrap repetitions}
}
\description{
The `nemoment()` function enables to implement the naive estimation of
the moments of the heterogeneous mean, the heterogeneous autocovariance,
and the heterogeneous autocorrelation.
The method is developed by Okui and Yanagi (2019).
For more details, see the package vignette with `vignette("panelhetero")`.
}
\examples{
data <- panelhetero::simulation(N = 300, S = 50)
panelhetero::nemoment(data = data)

}
\references{
Okui, R. and Yanagi, T., 2019.
Panel data analysis with heterogeneous dynamics.
Journal of Econometrics, 212(2), pp.451-475.
}
