% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-functions.R
\name{add_cif}
\alias{add_cif}
\alias{add_cif.default}
\title{Add cumulative incidence function to data}
\usage{
add_cif(newdata, object, ...)

\method{add_cif}{default}(
  newdata,
  object,
  ci = TRUE,
  overwrite = FALSE,
  alpha = 0.05,
  nsim = 500L,
  cause_var = "cause",
  time_var = NULL,
  ...
)
}
\arguments{
\item{newdata}{ A data frame or list containing the values of the model covariates at which predictions
  are required. If this is not provided then predictions corresponding to the
                original data are returned. If \code{newdata} is provided then
                it should contain all the variables needed for prediction: a
                warning is generated if not. See details for use with \code{link{linear.functional.terms}}. }

\item{object}{ a fitted \code{gam} object as produced by \code{gam()}.
                }

\item{...}{Further arguments passed to \code{\link[mgcv]{predict.gam}} and
\code{\link{get_hazard}}}

\item{ci}{\code{logical}. Indicates if confidence intervals should be
calculated. Defaults to \code{TRUE}.}

\item{overwrite}{Should hazard columns be overwritten if already present in
the data set? Defaults to \code{FALSE}. If \code{TRUE}, columns with names
\code{c("hazard", "se", "lower", "upper")} will be overwritten.}

\item{alpha}{The alpha level for confidence/credible intervals.}

\item{nsim}{Number of simulations (draws from posterior of estimated coefficients)
on which estimation of CIFs and their confidence/credible intervals will be
based on.}

\item{cause_var}{Character. Column name of the 'cause' variable.}

\item{time_var}{Name of the variable used for the baseline hazard. If
not given, defaults to \code{"tend"} for \code{\link[mgcv]{gam}} fits, else
\code{"interval"}. The latter is assumed to be a factor, the former
numeric.}
}
\description{
Add cumulative incidence function to data
}
