test_that("read_junior_pam_data junior_pam_20250613.csv - default", {
  test_data_file <- file.path(getwd(), "data", "junior_pam_20250613.csv")
  data <- read_junior_pam_data(test_data_file)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 50)
  expect_equal(par[3], 90)
  expect_equal(par[4], 130)
  expect_equal(par[5], 180)
  expect_equal(par[6], 250)
  expect_equal(par[7], 380)
  expect_equal(par[8], 570)
  expect_equal(par[9], 840)
  expect_equal(par[10], 1250)
  expect_equal(par[11], 1640)
  expect_equal(par[12], 2300)
  expect_equal(par[13], 3000)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], NA_real_)
  expect_equal(yield_1[2], NA_real_)
  expect_equal(yield_1[3], NA_real_)
  expect_equal(yield_1[4], NA_real_)
  expect_equal(yield_1[5], NA_real_)
  expect_equal(yield_1[6], NA_real_)
  expect_equal(yield_1[7], NA_real_)
  expect_equal(yield_1[8], NA_real_)
  expect_equal(yield_1[9], NA_real_)
  expect_equal(yield_1[10], NA_real_)
  expect_equal(yield_1[11], NA_real_)
  expect_equal(yield_1[12], NA_real_)
  expect_equal(yield_1[13], NA_real_)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.788)
  expect_equal(yield_2[2], 0.623)
  expect_equal(yield_2[3], 0.596)
  expect_equal(yield_2[4], 0.547)
  expect_equal(yield_2[5], 0.485)
  expect_equal(yield_2[6], 0.411)
  expect_equal(yield_2[7], 0.315)
  expect_equal(yield_2[8], 0.234)
  expect_equal(yield_2[9], 0.164)
  expect_equal(yield_2[10], 0.115)
  expect_equal(yield_2[11], 0.092)
  expect_equal(yield_2[12], 0.059)
  expect_equal(yield_2[13], 0.045)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], NA_real_)
  expect_equal(etr_1[2], NA_real_)
  expect_equal(etr_1[3], NA_real_)
  expect_equal(etr_1[4], NA_real_)
  expect_equal(etr_1[5], NA_real_)
  expect_equal(etr_1[6], NA_real_)
  expect_equal(etr_1[7], NA_real_)
  expect_equal(etr_1[8], NA_real_)
  expect_equal(etr_1[9], NA_real_)
  expect_equal(etr_1[10], NA_real_)
  expect_equal(etr_1[11], NA_real_)
  expect_equal(etr_1[12], NA_real_)
  expect_equal(etr_1[13], NA_real_)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 13.083)
  expect_equal(etr_2[3], 22.5288)
  expect_equal(etr_2[4], 29.8662)
  expect_equal(etr_2[5], 36.666)
  expect_equal(etr_2[6], 43.155)
  expect_equal(etr_2[7], 50.274)
  expect_equal(etr_2[8], 56.0196)
  expect_equal(etr_2[9], 57.8592)
  expect_equal(etr_2[10], 60.375)
  expect_equal(etr_2[11], 63.3696)
  expect_equal(etr_2[12], 56.994)
  expect_equal(etr_2[13], 56.7)
})

test_that("read_junior_pam_data junior_pam_20250613.csv - etr_factor 0.5", {
  test_data_file <- file.path(getwd(), "data", "junior_pam_20250613.csv")
  data <- read_junior_pam_data(test_data_file, etr_factor = 0.5)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 50)
  expect_equal(par[3], 90)
  expect_equal(par[4], 130)
  expect_equal(par[5], 180)
  expect_equal(par[6], 250)
  expect_equal(par[7], 380)
  expect_equal(par[8], 570)
  expect_equal(par[9], 840)
  expect_equal(par[10], 1250)
  expect_equal(par[11], 1640)
  expect_equal(par[12], 2300)
  expect_equal(par[13], 3000)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], NA_real_)
  expect_equal(yield_1[2], NA_real_)
  expect_equal(yield_1[3], NA_real_)
  expect_equal(yield_1[4], NA_real_)
  expect_equal(yield_1[5], NA_real_)
  expect_equal(yield_1[6], NA_real_)
  expect_equal(yield_1[7], NA_real_)
  expect_equal(yield_1[8], NA_real_)
  expect_equal(yield_1[9], NA_real_)
  expect_equal(yield_1[10], NA_real_)
  expect_equal(yield_1[11], NA_real_)
  expect_equal(yield_1[12], NA_real_)
  expect_equal(yield_1[13], NA_real_)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.788)
  expect_equal(yield_2[2], 0.623)
  expect_equal(yield_2[3], 0.596)
  expect_equal(yield_2[4], 0.547)
  expect_equal(yield_2[5], 0.485)
  expect_equal(yield_2[6], 0.411)
  expect_equal(yield_2[7], 0.315)
  expect_equal(yield_2[8], 0.234)
  expect_equal(yield_2[9], 0.164)
  expect_equal(yield_2[10], 0.115)
  expect_equal(yield_2[11], 0.092)
  expect_equal(yield_2[12], 0.059)
  expect_equal(yield_2[13], 0.045)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], NA_real_)
  expect_equal(etr_1[2], NA_real_)
  expect_equal(etr_1[3], NA_real_)
  expect_equal(etr_1[4], NA_real_)
  expect_equal(etr_1[5], NA_real_)
  expect_equal(etr_1[6], NA_real_)
  expect_equal(etr_1[7], NA_real_)
  expect_equal(etr_1[8], NA_real_)
  expect_equal(etr_1[9], NA_real_)
  expect_equal(etr_1[10], NA_real_)
  expect_equal(etr_1[11], NA_real_)
  expect_equal(etr_1[12], NA_real_)
  expect_equal(etr_1[13], NA_real_)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 7.7875)
  expect_equal(etr_2[3], 13.41)
  expect_equal(etr_2[4], 17.7775)
  expect_equal(etr_2[5], 21.825)
  expect_equal(etr_2[6], 25.6875)
  expect_equal(etr_2[7], 29.925)
  expect_equal(etr_2[8], 33.345)
  expect_equal(etr_2[9], 34.44)
  expect_equal(etr_2[10], 35.9375)
  expect_equal(etr_2[11], 37.72)
  expect_equal(etr_2[12], 33.925)
  expect_equal(etr_2[13], 33.75)
})

test_that("read_junior_pam_data junior_pam_20250613.csv - fraction_photosystem > 1", {
  test_data_file <- file.path(getwd(), "data", "junior_pam_20250613.csv")

  expect_error(read_junior_pam_data(test_data_file, fraction_photosystem_I = 0.9, fraction_photosystem_II = 0.2))
})

test_that("read_junior_pam_data junior_pam_20250613.csv - fraction_photosystem_I = 0.2, fraction_photosystem_II = 0.8", {
  test_data_file <- file.path(getwd(), "data", "junior_pam_20250613.csv")
  data <- read_junior_pam_data(test_data_file, fraction_photosystem_I = 0.2, fraction_photosystem_II = 0.8)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 50)
  expect_equal(par[3], 90)
  expect_equal(par[4], 130)
  expect_equal(par[5], 180)
  expect_equal(par[6], 250)
  expect_equal(par[7], 380)
  expect_equal(par[8], 570)
  expect_equal(par[9], 840)
  expect_equal(par[10], 1250)
  expect_equal(par[11], 1640)
  expect_equal(par[12], 2300)
  expect_equal(par[13], 3000)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], NA_real_)
  expect_equal(yield_1[2], NA_real_)
  expect_equal(yield_1[3], NA_real_)
  expect_equal(yield_1[4], NA_real_)
  expect_equal(yield_1[5], NA_real_)
  expect_equal(yield_1[6], NA_real_)
  expect_equal(yield_1[7], NA_real_)
  expect_equal(yield_1[8], NA_real_)
  expect_equal(yield_1[9], NA_real_)
  expect_equal(yield_1[10], NA_real_)
  expect_equal(yield_1[11], NA_real_)
  expect_equal(yield_1[12], NA_real_)
  expect_equal(yield_1[13], NA_real_)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.788)
  expect_equal(yield_2[2], 0.623)
  expect_equal(yield_2[3], 0.596)
  expect_equal(yield_2[4], 0.547)
  expect_equal(yield_2[5], 0.485)
  expect_equal(yield_2[6], 0.411)
  expect_equal(yield_2[7], 0.315)
  expect_equal(yield_2[8], 0.234)
  expect_equal(yield_2[9], 0.164)
  expect_equal(yield_2[10], 0.115)
  expect_equal(yield_2[11], 0.092)
  expect_equal(yield_2[12], 0.059)
  expect_equal(yield_2[13], 0.045)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], NA_real_)
  expect_equal(etr_1[2], NA_real_)
  expect_equal(etr_1[3], NA_real_)
  expect_equal(etr_1[4], NA_real_)
  expect_equal(etr_1[5], NA_real_)
  expect_equal(etr_1[6], NA_real_)
  expect_equal(etr_1[7], NA_real_)
  expect_equal(etr_1[8], NA_real_)
  expect_equal(etr_1[9], NA_real_)
  expect_equal(etr_1[10], NA_real_)
  expect_equal(etr_1[11], NA_real_)
  expect_equal(etr_1[12], NA_real_)
  expect_equal(etr_1[13], NA_real_)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 20.9328)
  expect_equal(etr_2[3], 36.04608)
  expect_equal(etr_2[4], 47.78592)
  expect_equal(etr_2[5], 58.6656)
  expect_equal(etr_2[6], 69.048)
  expect_equal(etr_2[7], 80.4384)
  expect_equal(etr_2[8], 89.63136)
  expect_equal(etr_2[9], 92.57472)
  expect_equal(etr_2[10], 96.6)
  expect_equal(etr_2[11], 101.39136)
  expect_equal(etr_2[12], 91.1904)
  expect_equal(etr_2[13], 90.72)
})
