% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paletteer_d.R
\name{paletteer_d}
\alias{paletteer_d}
\title{Get discrete palette by package and name}
\usage{
paletteer_d(package, palette, n, direction = 1, type = c("discrete",
  "continuous"))
}
\arguments{
\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{Name of palette as string or symbol.}

\item{n}{Number of colors desired. If omitted, returns complete palette.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{type}{Either "discrete" or "continuous". Colors are interpolated if
"continuous" is picked. Defaults to "discrete".}
}
\value{
A vector of colors.
}
\description{
Available package/palette combinations are available in the data.frame
\code{\link[paletteer]{palettes_d_names}}. Both \code{package} and \code{palette}
can be supplied as symbols or strings.
}
\examples{
paletteer_d("nord", "frost")
paletteer_d("wesanderson", "Royal1", 3)
paletteer_d("Redmonder", "dPBIPuOr", 14, type = "continuous")
}
