test_that("simFossilRecord counts taxa in final output correctly", {

library(paleotree)

saved_seed <- c(
10403L, 303L, 1036177046L, -725760437L, -603627585L, -2122159062L, 
1171112377L, 1813269596L, 1251795192L, -213283628L, -282099126L, 
-1747914946L, 1479354505L, -226129111L, -1120084489L, -1844943529L, 
-394320296L, 1482511303L, 520906459L, -1951809137L, 1363632276L, 
798494342L, -2007130438L, -329083480L, 101103537L, -1804498241L, 
-52036596L, -129149475L, -2092284404L, -1512309709L, 1832373955L, 
485517067L, -374388006L, 911286622L, -174795653L, -325613373L, 
-2107933316L, 277623990L, 1126034325L, 967219322L, -622684168L, 
-1823542214L, -551718064L, 1617509018L, 1812905781L, -1516266781L, 
1813298003L, 1527126533L, 2029334767L, 1508293823L, 573491295L, 
2030201913L, 1429423985L, -664131862L, -1679318866L, -1872359163L, 
265285104L, 531042338L, -1517572259L, 1723827471L, 1044677938L, 
201398378L, -1180780811L, -534061217L, -1359132116L, 1990560448L, 
1329557495L, -370074826L, 2014199603L, 1868774009L, 1179426044L, 
-1892744141L, -436358876L, -1469361412L, 736044398L, -813026776L, 
557992276L, -1932790469L, -245804683L, 1942411579L, -2089574479L, 
-1229172885L, 928752528L, 1832764069L, 612961041L, 1093393989L, 
-1206948333L, -1614768400L, 741416391L, -14895279L, 2137581486L, 
-1917328695L, -695024185L, 1880390052L, 1631603462L, -360094324L, 
-348004426L, -16043754L, -345223205L, 232485093L, 958748896L, 
1926422718L, 1561630779L, -188456126L, 1666740166L, 398615854L, 
-1847754280L, -1014863579L, -1882484763L, -1292100414L, -323235067L, 
-1767230762L, 1729797189L, 192023476L, -997950437L, -923635969L, 
330197793L, -1741808408L, -647487620L, 1669006421L, -737753468L, 
367880042L, -1377892731L, -98615161L, -1354440600L, -1012883369L, 
-494649046L, -1098265353L, 979223029L, 1969861207L, -1860937136L, 
-542474266L, 526670415L, 1592982404L, -1536130542L, 1997554069L, 
-733554927L, -445414682L, 449671441L, -686865517L, -1820400993L, 
1217427759L, -722062750L, -967057183L, -250129821L, -1329064563L, 
1735120055L, 1471134075L, -596551551L, 400278485L, -808935108L, 
1973326804L, -672078377L, -1247275109L, 704941579L, -1550040087L, 
743138592L, 930990651L, -1607917878L, 2060963439L, 488682191L, 
-1434272503L, -978515500L, 1771885101L, -1677639025L, -1654052608L, 
-1101520546L, 902509822L, -1401523511L, 327926094L, -1030629990L, 
2022730738L, 515803255L, 769626375L, 1598251218L, 534851199L, 
148219296L, -304163521L, 1576747397L, 1186404999L, 956828826L, 
-870403419L, -244447980L, 558774041L, -1298988907L, 1582514961L, 
2092505395L, 496186877L, -671051319L, -1211957854L, -2083981219L, 
-1228808038L, -1687467628L, 570329149L, 1438490807L, -839725046L, 
-195148353L, -1831062019L, -526424982L, -1403433410L, 1959280201L, 
1900142734L, -1538855153L, -237828605L, 309866360L, 1070678719L, 
-1923175181L, -22056925L, 1436768120L, 488972697L, 1563872704L, 
692764883L, -1262136728L, -259531523L, 742157953L, -278832557L, 
-1912370876L, -1725114612L, -2017225921L, 1786469420L, -714778879L, 
-386754820L, -289194725L, 1991342509L, 748149039L, -1730807078L, 
-986115353L, 1379519120L, -1636906231L, -1098353257L, 1175377114L, 
739371747L, -774448289L, 36333629L, 1695467443L, -808656582L, 
788592911L, -1999354502L, -727953197L, -1451370889L, 578104954L, 
2090480299L, -205444724L, -2026816015L, 377378048L, 1595574605L, 
2096603925L, 1133713232L, 529713193L, 1066966412L, 170149274L, 
-452020930L, 1319893381L, -468923166L, -1387018709L, 315724425L, 
1771839137L, -1076429625L, -594124435L, 1764573655L, 2126400933L, 
1175462653L, -735341159L, 776851440L, -593085224L, -321080038L, 
232951242L, 53159976L, 761226266L, 1132230380L, 156003327L, 291871859L, 
-1365420732L, -434704293L, -710699094L, 1945550183L, -338164208L, 
1061636523L, 787014732L, 375052835L, -1042702321L, 294963721L, 
-1659043318L, -805206448L, -795524141L, 2042561387L, -295607247L, 
-2024779994L, -918154772L, 417230217L, -1118697097L, -1943909346L, 
2057226244L, -2072304295L, 949559705L, 178723448L, -1356796307L, 
715277674L, 1998981989L, 927560545L, -944019214L, -1807447796L, 
-1067174394L, 929760665L, -969411345L, 1299327975L, -170000888L, 
-168641432L, -1624203151L, 1614982366L, -1102979733L, 526444388L, 
-1237966628L, -59359861L, -7557844L, 1728637406L, 1804982761L, 
1951396818L, 1824627493L, -1081218533L, 957385966L, -82687539L, 
-1107928069L, -760534415L, -747053325L, -2043224827L, -142649540L, 
-1237090611L, -2090174091L, -546057316L, -1364368341L, 2139897899L, 
2029754430L, 312901099L, -1624639036L, -426243303L, -58536998L, 
2139596980L, -1350752873L, 759504442L, -1245417258L, 1965208412L, 
-1025890175L, -288698290L, 1229142901L, -1845366857L, 138047863L, 
-1645968706L, -883944772L, 1983029056L, 2123088736L, -1036855518L, 
1040522211L, -130790537L, -669375180L, -1542718749L, -1627453842L, 
1242443435L, 289588620L, 1917801621L, -92759993L, -1162805136L, 
-1818574900L, -1900424812L, 2076434870L, 1122995521L, 57838530L, 
-21748160L, 1654745439L, 309697198L, 1981688554L, 959837411L, 
2025789341L, -238794708L, 655024344L, 704126179L, -1768600698L, 
1530823687L, 470642353L, 628088689L, -1634098529L, 2100775251L, 
-1831693367L, 803932160L, 269186350L, -1427162903L, -275859568L, 
-1907002927L, 944926036L, 1261943794L, 234591008L, 2015259243L, 
1466389722L, -814811631L, -301244554L, 933571263L, -919295077L, 
643740555L, 1982189819L, -92886009L, 1839445112L, 530726933L, 
-30429027L, 909139425L, 1675092771L, 1525325303L, -1012012860L, 
-2129076508L, -1275547874L, -786794670L, -634020966L, -1380552024L, 
1799434876L, -373432374L, 2106397479L, 1438206358L, 25617167L, 
1683848708L, -975738690L, -893024067L, 1422919542L, -1039873266L, 
-836020924L, -2014220417L, -51227525L, 959414432L, -263064426L, 
-1571923444L, -384174176L, 931713660L, -1377280537L, 783269020L, 
-1755017000L, 2108519123L, 1075384373L, 1533131586L, 107649287L, 
-1036482435L, 1454661956L, 7111678L, 877069561L, -1178965150L, 
988096567L, -1592701019L, 1369993623L, -1239830980L, 1900397670L, 
-2006451502L, 66598832L, 1634584859L, -494843585L, 1546245710L, 
-1259964741L, -1511929382L, -1699382782L, -1569135383L, -1855288679L, 
1572531575L, 1188833347L, 77292316L, -293804264L, 1369171035L, 
624721134L, 1447971223L, 367352974L, 1453153865L, 780218206L, 
-1193171626L, -1297126278L, 728806201L, -1236394289L, 1490635819L, 
-1335919000L, -1441203162L, -214059630L, -126767481L, 249373431L, 
121651816L, 527802137L, 1710661605L, -1889962302L, 1920053701L, 
282929555L, -209979458L, 1650023316L, 828380226L, 1840536757L, 
361814822L, -1351058151L, -650317475L, 523383454L, -1269330190L, 
1035012273L, 1951314297L, -76348151L, -748546156L, 1736320939L, 
249694082L, 769260960L, 1189335726L, -61995093L, -908805405L, 
-1672687623L, -846566850L, -1514984348L, -326300704L, -1203336601L, 
-1832777826L, 998974845L, 958642958L, -1191035094L, 1232705919L, 
1946895008L, -1116554897L, 119948481L, 206278501L, 1055406888L, 
-1126905267L, -1381529674L, 1715390604L, -403226326L, 1657557274L, 
-1745452427L, -653279441L, 305535934L, -633168821L, 1599674569L, 
-57359847L, 1823007512L, -1209471627L, -1524930416L, 620060603L, 
1369009780L, -612403887L, 1967985996L, -1102448112L, -457474425L, 
193098413L, -1962273302L, -293008069L, -88771549L, -941710644L, 
1089071670L, 941829365L, 387168351L, -1919321224L, -459663973L, 
-295030194L, -1101331958L, 7766846L, 1049045926L, 2024131963L, 
-1863745508L, 420922347L, -1309789455L, 110069083L, 1420482287L, 
-69061584L, -504516225L, -1642672094L, -1402916323L, 76197491L, 
-1098139476L, -39726048L, 23168622L, 161227673L, -661774720L, 
-1254507383L, -557156308L, -833527324L, -301900797L, -591795567L, 
1495512376L, -1737531957L, -1170814733L, 283407367L, 757289171L, 
1077703134L, -837133495L, 1073376497L, 985534916L, 220745082L, 
-441865274L, 1486110261L, 767013297L, 1039305711L, 570113302L, 
713240113L, -1082876692L, 707479413L, -2145507191L, -1892230792L, 
-1061457644L, 527032848L, -1111744620L, 568047372L, -335434225L, 
2113378135L, -1029827013L, -1006580140L, -1547069777L, -1189203543L, 
1721744819L, -73242054L, -67077446L, 1637380594L, -1152070973L, 
-1453961669L, -1858835533L, -932574288L, -1944796885L, 538023003L, 
329757059L, 1893611092L, 521907510L, 1460378420L, 753252322L, 
-1241359828L, 1491406989L, 85741714L, -2048718018L, -1021418552L, 
1828813134L, -125060567L, -1933879857L, 1757722544L
)

.Random.seed <- saved_seed

res <- simFossilRecord(
	p = 0.1, 
	q = 0.1, 
	r = 0.1,
	nTotalTaxa = 10,
	nExtant = 0,
	nruns = 1,
	plot = TRUE
	)

testthat::skip_on_cran()
testthat::skip_on_travis()

expect_equal_to_reference(res, update =TRUE,
	file = ".//references//countFinalTaxa//res")
	
})