% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfectParsCharTree.R
\name{perfectParsCharTree}
\alias{perfectParsCharTree}
\title{Simulate a Set of Parsimony-Informative Characters for a Phylogeny}
\usage{
perfectParsCharTree(tree, nchar)
}
\arguments{
\item{tree}{A phylogeny of class 'phylo'}

\item{nchar}{Number of parsimonious binary characters to simulate on the phylogeny.}
}
\value{
A matrix of \code{nchar} parsimonious binary characters for each taxon on \code{tree}, with states 0 and 1.
}
\description{
Creates a simulated set of parsimony-informative characters for a given rooted phylogeny,
with characters shared out equally across nodes in the phylogeny, with any remaining characters
assigned randomly to nodes.
}
\details{
This function takes some a tree and places a number of binary characters on the tree, with character states arranged  
as if the derived condition was gained once, at a single node, and never lost. This ensures that the resulting simulated
character matrices have no character conflict, supporting a single solution under maximum parsimony. 

If \code{nchar} is greater than the number of nodes on the input phylogeny (ignoring the root), then characters are first
placed to evenly cover all nodes, with as many full passes of tree as possible. Any characters in excess are placed at random
nodes, without replacement. In other words, if a tree has 10 nodes (plus the root) and 25 characters are simulated, 20 of those
characters will consist of two 10-character 'full passes' of the tree. The remaining five will be randomly dropped on the tree.

If few characters are simulated than the number of nodes, these are randomly placed on the given topology without replacement,
just as described above. 

This function assumes, like almost every function in paleotree, that the tree given is rooted, even if the
most basal node is a polytomy.
}
\examples{
data(retiolitinae)

#fewer characters than nodes
perfectParsCharTree(retioTree,nchar=10)

#same as number of nodes (minus root)
perfectParsCharTree(retioTree,nchar=12)

#more characters than the number of nodes
perfectParsCharTree(retioTree,nchar=20)
}
\author{
David W. Bapst
}
