% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaleoPopResults.R
\name{PaleoPopResults}
\alias{PaleoPopResults}
\title{R6 class representing paleopop simulator results.}
\description{
\code{\link[R6:R6Class]{R6}} class for encapsulating and dynamically generating
spatially-explicit \code{\link{paleopop_simulator}} results, as well as optional
re-generated \code{\link{Generator}} for niche carrying capacity and/or human
density.
}
\examples{
library(raster)
library(poems)
# Ring Island example region
coordinates <- data.frame(x = rep(seq(-178.02, -178.06, -0.01), 5),
                          y = rep(seq(19.02, 19.06, 0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
sealevel_raster <- template_raster
template_raster[][c(7:9, 12:14, 17:19)] <- NA # make Ring Island
sealevel_raster[][c(7:9, 12:14, 17:18)] <- NA
raster_stack <- raster::stack(x = append(replicate(9, template_raster), sealevel_raster))
region <- PaleoRegion$new(template_raster = raster_stack)

# Model template
model_template <- PaleoPopModel$new(
region = region,
time_steps = 10,
years_per_step = 12, # years per generational time-step
standard_deviation = 0.1,
growth_rate_max = 0.6,
harvest = FALSE,
populations = region$region_cells,
initial_abundance = seq(9000, 0, -1000),
transition_rate = 1.0,
carrying_capacity = rep(1000, 17),
dispersal = (!diag(nrow = 17, ncol = 17))*0.05,
density_dependence = "logistic",
dispersal_target_k = 10,
occupancy_threshold = 1, 
abundance_threshold = 10,
results_selection = c("abundance")
)

# Simulations
results <- paleopop_simulator(model_template)

# Results
results_model <- PaleoPopResults$new(results = results, region = region, time_steps = 10)
results_model$extirpation # cells where the population goes to zero are marked 1
results_model$occupancy # indicates with 0 and 1 which cells are occupied at each time step
results_model$ema # expected minimum abundance

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{\link[poems:SimulationResults]{poems::SimulationResults}} -> \code{PaleoPopResults}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population coordinates (WGS84) in longitude (degrees West) and latitude (degrees North).}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{burn_in_steps}}{Optional number of initial 'burn-in' time steps to be ignored.}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for each cell at each time-step of the simulation including burn-in.}

\item{\code{trend_interval}}{Optional time-step range (indices) for trend calculations (assumes indices begin after the burn-in when utilized).}

\item{\code{abundance}}{Matrix of population abundance across simulation time-steps (\emph{populations} rows by \emph{duration} columns).}

\item{\code{abundance_trend}}{Trend or average Sen's \code{\link[trend:sens.slope]{slope}} of total abundance (optionally across a time-step interval).}

\item{\code{ema}}{Matrix of population expected minimum abundance (EMA) across simulation time-steps (\emph{populations} rows by \emph{duration} columns).}

\item{\code{extirpation}}{Array of population extirpation times.}

\item{\code{extinction_location}}{The weighted centroid of cells occupied in the time-step prior to the extirpation of all populations (if occurred).}

\item{\code{harvested}}{Matrix of the number of animals harvested from each population at each time-step (\emph{populations} rows by \emph{duration} columns).}

\item{\code{occupancy}}{Array of the number of populations occupied at each time-step.}

\item{\code{carrying_capacity}}{Optional matrix of simulation input carrying capacity to be combined with results (\emph{populations} rows by \emph{duration} columns).}

\item{\code{human_density}}{Optional matrix of simulation input human density to be combined with results (\emph{populations} rows by \emph{duration} columns).}

\item{\code{all}}{Nested simulation results for all cells.}

\item{\code{parent}}{Parent simulation results for individual cells.}

\item{\code{default}}{Default value/attribute utilized when applying primitive metric functions (e.g. max) to the results.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PaleoPopResults-clone}{\code{PaleoPopResults$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="get_attribute_names"><a href='../../poems/html/SimulationResults.html#method-SimulationResults-get_attribute_names'><code>poems::SimulationResults$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="get_attributes"><a href='../../poems/html/SimulationResults.html#method-SimulationResults-get_attributes'><code>poems::SimulationResults$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="initialize"><a href='../../poems/html/SimulationResults.html#method-SimulationResults-initialize'><code>poems::SimulationResults$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="new_clone"><a href='../../poems/html/SimulationResults.html#method-SimulationResults-new_clone'><code>poems::SimulationResults$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="set_attributes"><a href='../../poems/html/SimulationResults.html#method-SimulationResults-set_attributes'><code>poems::SimulationResults$set_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaleoPopResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PaleoPopResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoPopResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
