% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfAddData.R
\name{rbind.pfAddData}
\alias{rbind.pfAddData}
\title{rbind.pfAddData}
\usage{
\method{rbind}{pfAddData}(...)
}
\arguments{
\item{...}{two or more objects returned by pfAddData}
}
\value{
An object of the class "pfAddData" (list)
}
\description{
rbind two or more pfAddData objects, this enable to add charcoal series stored using multiple types,
see type argument of \code{\link[paleofire]{pfAddData}} for details.
}
\examples{
\dontrun{
files=c("http://blarquez.com/public/data//Ben.csv",
       "http://blarquez.com/public/data/Small.csv")
metadata=c("http://blarquez.com/public/data/metadata.csv")

mydata1=pfAddData(files=files,type="CharAnalysis")
mydata2=pfAddData(files=files,metadata=metadata,type="CharAnalysis")
mydata=rbind(mydata1,mydata2)

TR1=pfTransform(add=mydata, method=c("MinMax","Box-Cox","Z-Score"),
               BasePeriod=c(200,2000))
COMP2=pfCompositeLF(TR1, tarAge=seq(-50,8000,20), hw=500, nboot=100)
plot(COMP2)
}


}
\author{
O. Blarquez
}
\seealso{
\code{\link[paleofire]{pfAddData}}
}

