% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comapre.R
\name{pac_compare_versions}
\alias{pac_compare_versions}
\title{Compare DESCRIPTION files dependencies between specific CRAN packages versions}
\usage{
pac_compare_versions(
  pac,
  old = NULL,
  new = NULL,
  fields = c("Imports", "Depends", "LinkingTo"),
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{character a package name.}

\item{old}{character an old version of package, default local version. Default: NULL}

\item{new}{character a new version of package, default newest version. Default: NULL}

\item{fields}{a character vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector. Default: \code{.libPaths()}}

\item{repos}{character the base URL of the CRAN repository to use. Default "https://cran.rstudio.org"}
}
\value{
data.frame with 4 columns.
\describe{
\item{Package}{character package names.}
\item{Version.OLD}{character versions of dependencies required by an old package version.}
\item{Version.NEW}{character versions of dependencies required by a new package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
}
}
\description{
using the remote github CRAN mirror to compare DESCRIPTION files dependencies between specific packages versions.
}
\examples{
\dontrun{
pac_compare_versions("memoise", "0.2.1", "2.0.0")
pac_compare_versions("memoise", "0.2.1")
# local version to newest one
pac_compare_versions("memoise")
}
}
