% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_codetags}
\alias{check_codetags}
\title{Check for Code Tags}
\usage{
check_codetags(
  path = ".",
  exclude_pattern = "\\\\.Rcheck/",
  include_pattern = "\\\\.[Rr]$|\\\\.[Rr]md$",
  pattern = "XXX:|FIXME:|TODO:"
)
}
\arguments{
\item{path}{to a directory, typically a package root.}

\item{exclude_pattern}{A pattern for exclusions based on the file names.
Stronger than \code{include_pattern}.}

\item{include_pattern}{A pattern for inclusions based on the file names.}

\item{pattern}{The pattern to search for.}
}
\value{
A character vector of hits.
}
\description{
You do use code tags
(see \href{https://www.python.org/dev/peps/pep-0350/}{PEP 350} for example)?
This function searches for files under a directory containing such tags.
}
\examples{
dir <- system.file("templates", package = "packager")
check_codetags(dir)
}
\seealso{
Other maintenance functions: 
\code{\link{check_archive}()},
\code{\link{check_cyclomatic_complexity}()},
\code{\link{check_news}()},
\code{\link{check_usage}()},
\code{\link{get_check_status}()}
}
\concept{maintenance functions}
