% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{strategy}
\alias{strategy}
\title{Definition of strategy - or arm}
\usage{
strategy(trans_mat, states, name, trans_cost = NULL, trans_util = NULL)
}
\arguments{
\item{trans_mat}{transition matrix}

\item{states}{health states}

\item{name}{name of the strategy}

\item{trans_cost}{values of costs if these are attached to transitions}

\item{trans_util}{values of utility if these are attached to transitions}
}
\value{
object strategy
}
\description{
Definition of strategy - or arm
}
\details{
Defining strategy keeping all transition matrix, states and names
together to use in defining Markov model
}
\examples{
tmat <- rbind(c(1, 2), c(3, 4))
colnames(tmat) <- rownames(tmat) <- c("Healthy", "Dead")
tm <- populate_transition_matrix(2, tmat, c(0.5, 0.5, 0, 1))
a <- health_state("Healthy", 1, 1, 0, FALSE)
b <- health_state("Dead", 1, 0.5, 0, FALSE)
states <- combine_state(a, b)
strategy(tm, states, "intervention")
}
