% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/4a_deterministic_sensitivity_analysis_functions.R
\name{plot_dsa}
\alias{plot_dsa}
\title{Function to plot results of sensitivity analysis do_sensitivity_analysis()}
\usage{
plot_dsa(
  result_dsa_control,
  plotfor,
  type = "range",
  result_dsa_treat = NULL,
  threshold = NULL,
  comparator = NULL
)
}
\arguments{
\item{result_dsa_control}{result from deterministic sensitivity analysis
for first or control model}

\item{plotfor}{the variable to plotfor e.g. cost, utility NMB etc}

\item{type}{type of analysis, range or difference}

\item{result_dsa_treat}{result from deterministic sensitivity analysis
for the comparative Markov model}

\item{threshold}{threshold value of WTP}

\item{comparator}{the strategy to be compared with}
}
\value{
plot of  sensitivity analysis
}
\description{
Function to plot results of sensitivity analysis do_sensitivity_analysis()
}
\examples{
\donttest{
param_list <- define_parameters(
cost_zido = 2278, cost_direct_med_A = 1701,
cost_comm_care_A = 1055, cost_direct_med_B = 1774,
cost_comm_care_B = 1278,
cost_direct_med_C = 6948, cost_comm_care_C = 2059,
tpAtoA = 1251 / (1251 + 483),
tpAtoB = 350 / (350 + 1384), tpAtoC = 116 / (116 + 1618),
tpAtoD = 17 / (17 + 1717),
tpBtoB = 731 / (731 + 527), tpBtoC = 512 / (512 + 746),
tpBtoD = 15 / (15 + 1243),
tpCtoC = 1312 / (1312 + 437), tpCtoD = 437 / (437 + 1312),
tpDtoD = 1,
cost_health_A = "cost_direct_med_A +  cost_comm_care_A",
cost_health_B = "cost_direct_med_B +  cost_comm_care_B",
cost_health_C = "cost_direct_med_C +  cost_comm_care_C",
cost_drug = "cost_zido")
low_values <- define_parameters(cost_direct_med_B = 177.4,
cost_comm_care_C = 205.9)
upp_values <- define_parameters(cost_direct_med_B = 17740,
cost_comm_care_C = 20590)
A <- health_state("A", cost = "cost_health_A +  cost_drug ",
utility = 1)
B <- health_state("B", cost = "cost_health_B + cost_drug",
utility = 1)
C <- health_state("C", cost = "cost_health_C + cost_drug",
utility = 1)
D <- health_state("D", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3, 4), c(NA, 5, 6, 7), c(NA, NA, 8, 9),
c(NA, NA, NA, 10))
colnames(tmat) <- rownames(tmat) <- c("A", "B", "C", "D")
tm <- populate_transition_matrix(4, tmat, c("tpAtoA", "tpAtoB", "tpAtoC",
"tpAtoD","tpBtoB", "tpBtoC", "tpBtoD", "tpCtoC", "tpCtoD", "tpDtoD"),
colnames(tmat))
health_states <- combine_state(A, B, C, D)
mono_strategy <- strategy(tm, health_states, "mono")
mono_markov <- markov_model(mono_strategy, 20, c(1, 0, 0, 0),
discount = c(0.06, 0), param_list)
param_table <- define_parameters_sens_anal(param_list, low_values,
upp_values)
result <- do_sensitivity_analysis(mono_markov, param_table)
param_list_treat <- define_parameters(
cost_zido = 3000, cost_direct_med_A = 890,
cost_comm_care_A = 8976, cost_direct_med_B = 2345,
cost_comm_care_B = 1278,
cost_direct_med_C = 6948, cost_comm_care_C = 2059,
tpAtoA = 1251 / (1251 + 483),
tpAtoB = 350 / (350 + 1384), tpAtoC = 116 / (116 + 1618),
tpAtoD = 17 / (17 + 1717),
tpBtoB = 731 / (731 + 527), tpBtoC = 512 / (512 + 746),
tpBtoD = 15 / (15 + 1243),
tpCtoC = 1312 / (1312 + 437), tpCtoD = 437 / (437 + 1312),
tpDtoD = 1,
cost_health_A = "cost_direct_med_A +  cost_comm_care_A",
cost_health_B = "cost_direct_med_B +  cost_comm_care_B",
cost_health_C = "cost_direct_med_C +  cost_comm_care_C",
cost_drug = "cost_zido")
treat_strategy <- strategy(tm, health_states, "treat")
treat_markov <- markov_model(treat_strategy, 20, c(1, 0, 0, 0),
discount = c(0.06, 0), param_list_treat)
treat_low_values <- define_parameters(cost_direct_med_B = 234.5,
cost_comm_care_C = 694.8)
treat_upp_values <- define_parameters(cost_direct_med_B = 23450,
 cost_comm_care_C = 69480)
param_table_treat <- define_parameters_sens_anal(param_list_treat,
treat_low_values,treat_upp_values)
result_treat <- do_sensitivity_analysis(treat_markov, param_table)
plot_dsa(result,"NMB","range",result_treat, 20000, "treat")
}
}
