#' Precipitation density
#'
#' Function for plotting (density) time-series of area averaged precipitation.
#'
#' @import data.table ggplot2
#' @importFrom methods as
#' @importFrom stats density
#' @param x a csv generated by \code{\link{make_ts}}
#' @param var a character string with the name of the variable to be used for the axis title
#' @param unit a character string with the variable's unit of measurement to be used for the axis title
#' @return ggplot object
#' @export

plot_density <- function(x, var = 'Precipitation', unit = 'mm'){
  x <- as.data.table(x)
  p00 <- ggplot(x, aes(x = value, after_stat(density))) +
    geom_histogram(color = "gray", fill = "#377eb8") +
    geom_density(color = "black", size = 1, linetype = "dashed") +
    theme_bw() +
    labs(y = "Density", x = paste0(var, ' [', unit, ']')) + 
    theme(plot.title = element_text(size=24),
          axis.text = element_text(size = 20),
          axis.title = element_text(size = 24))
  return(p00)
}