% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRecipe.R
\name{reformat_data}
\alias{reformat_data}
\title{Reformat the downloaded data sets into .Rds files}
\usage{
reformat_data(raw_folder_path = "./data/raw", name = "all")
}
\arguments{
\item{raw_folder_path}{a character string with the path where the "raw" folder is located.}

\item{name}{a character string with the name of the desired data set. Suitable options are:
\itemize{
\item{"all" for all of the below listed data sets (default),}
\item{"20cr" for 20CR v3,}
\item{"cmap" for CMAP standard version,}
\item{"cpc" for CPC-Global,}
\item{"cru_ts" for CRU_TS v4.05,}
\item{"ghcn" for GHCN-M v2}
\item{"gpcc" for GPCC v2018,}
\item{"gpcp" for GPCP v2.3,}
\item{"gpm_imergm" for GPM IMERGM Final v06,}
\item{"ncep" for NCEP/NCAR,}
\item{"ncep_doe" for NCEP/DOE,}
\item{"precl" for PRECL,}
\item{"trmm_3b43" for TRMM 3B43 v7,}
\item{"udel" for UDEL v501.}
}}
}
\value{
No return value, called to reformat the downloaded data sets into pRecipe objects.
}
\description{
The function \code{reformat_data} reformats the data sets into monthly total precipitation data.tables at 0.5 degree resolution.
}
\examples{
\dontrun{
reformat_data(tempdir())
reformat_data(tempdir(), c("gpm_imergm", "trmm_3b43"))
}
}
