% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logInspector.R
\name{logInspector}
\alias{logInspector}
\title{A class to perform a preliminary analysis on sequential data for Process Mining issues}
\usage{
logInspector()
}
\description{
This class aims at inspecting an event-log for descriptive analysis purposes. The public methods are:
               \itemize{
               \item \code{logInspector( ) } is the constructor of the class
               \item \code{loadDataset( ) } loads data taken from a \code{dataLoader::getData()} method, into a \code{logInspector()} object
               \item \code{getEventStats() } computes and returns event-related stats, such as absolute and relative events frequency
               \item \code{getProcessStats() } computes and returns process-related stats, such as absolute and relative processes frequency
               \item \code{plotEventStats( )} plots the event-related stats (input is the number of most frequent events it has to plot)
               \item \code{plotProcessStats( )} plots the process-related stats (input is the number of most frequent processes it has to plot)
               \item \code{timeDistribution.stats.plot( )} <not yet commented>
               }
               In order to better undestand the use of such methods, please visit: www.pminer.info

Parameter for \code{logInspector::plotEventStats()} and \code{logInspector::plotProcessStats()} methods is:
  \itemize{
   \item \code{num } the number of most frequent events/processes to plot
  }
}
\examples{
\dontrun{
# -----------------------------------------------
#  USING THE METHODS of the class
# -----------------------------------------------
obj.L<-dataLoader();   # create a Loader

# Load a .csv using "DES" and "ID" as column names to indicate events
# and Patient's ID
obj.L$load.csv(nomeFile = "../otherFiles/test_02.csv",
IDName = "ID",EVENTName = "DES",dateColumnName = "DATA")

# now create an object logInspector
obj.logI<-logInspector();

# load the data into logInspector object
obj.logI$loadDataset( obj.L$getData() );

# get event-related descriptive statistics
obj.logI$getEventStats();

# get process-related descriptive statistics
obj.logI$getProcessStats();

# plot event-related descriptive statistics
obj.logI$plotEventStats();

# plot process-related descriptive statistics
obj.logI$plotProcessStats()
}
}

