% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_index.R
\name{calculate_index}
\alias{calculate_index}
\alias{calculate_gov_response}
\alias{calculate_containment_health}
\alias{calculate_stringency}
\alias{calculate_economic_support}
\alias{calculate_indices}
\title{Calculate an OxCGRT index or indices}
\usage{
calculate_index(df, codes, tolerance)

calculate_gov_response(df)

calculate_containment_health(df)

calculate_stringency(df)

calculate_economic_support(df)

calculate_indices(df)
}
\arguments{
\item{df}{A data.frame produced by a call to \code{\link[=calculate_subindices]{calculate_subindices()}}.}

\item{codes}{A vector of policy type codes to use for the index calculation.}

\item{tolerance}{An integer specifying the number of missing values above
which index will not be calculated and reported.}
}
\value{
A numeric value for mean subindex scores of specified policy types.
For \code{\link[=calculate_indices]{calculate_indices()}}, a tibble calculated OxCGRT indices
}
\description{
Calculate an OxCGRT index or indices
}
\examples{
## Get policy actions data for Afghanistan on 1 September 2020
x <- get_data(json = get_json_actions(ccode = "AFG",
                                      from = NULL,
                                      to = "2020-09-01"))

## Calculate OxCGRT subindices
y <- calculate_subindices(df = x$policyActions)

## Calculate OxCGRT index
calculate_index(df = y,
                codes = c(paste("C", 1:8, sep = ""),
                          paste("E", 1:2, sep = ""),
                          paste("H", 1:3, sep = ""), "H6"),
                tolerance = 1)

## Calculate OxCGRT government response index
calculate_gov_response(df = y)

## Calculate OxCGRT containment and health index
calculate_containment_health(df = y)

## Calculate OxCGRT stringency index
calculate_stringency(df = y)

## Calculate OxCGRT economic support index
calculate_economic_support(df = y)

## Calculate all OxCGRT indices
calculate_indices(df = y)

}
\author{
Ernest Guevarra
}
